@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.EntityUptimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Entity Uptime.
 * @property daysPerMonth Gets the days per month.
 * @property hoursPerDay Gets the hours per day.
 */
public data class EntityUptimeArgs(
    public val daysPerMonth: Output<Int>? = null,
    public val hoursPerDay: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.EntityUptimeArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.EntityUptimeArgs =
        com.pulumi.azurenative.migrate.inputs.EntityUptimeArgs.builder()
            .daysPerMonth(daysPerMonth?.applyValue({ args0 -> args0 }))
            .hoursPerDay(hoursPerDay?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EntityUptimeArgs].
 */
@PulumiTagMarker
public class EntityUptimeArgsBuilder internal constructor() {
    private var daysPerMonth: Output<Int>? = null

    private var hoursPerDay: Output<Int>? = null

    /**
     * @param value Gets the days per month.
     */
    @JvmName("gepvdniaawepameo")
    public suspend fun daysPerMonth(`value`: Output<Int>) {
        this.daysPerMonth = value
    }

    /**
     * @param value Gets the hours per day.
     */
    @JvmName("cajnxvoshklbudjd")
    public suspend fun hoursPerDay(`value`: Output<Int>) {
        this.hoursPerDay = value
    }

    /**
     * @param value Gets the days per month.
     */
    @JvmName("dyewtitigivrrith")
    public suspend fun daysPerMonth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daysPerMonth = mapped
    }

    /**
     * @param value Gets the hours per day.
     */
    @JvmName("xmnqgcubmvpjaxge")
    public suspend fun hoursPerDay(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hoursPerDay = mapped
    }

    internal fun build(): EntityUptimeArgs = EntityUptimeArgs(
        daysPerMonth = daysPerMonth,
        hoursPerDay = hoursPerDay,
    )
}
