@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupName Unique name of a group within a project.
 * @property projectName Name of the Azure Migrate project.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 */
public data class GetGroupPlainArgs(
    public val groupName: String,
    public val projectName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetGroupPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetGroupPlainArgs.builder()
            .groupName(groupName.let({ args0 -> args0 }))
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGroupPlainArgs].
 */
@PulumiTagMarker
public class GetGroupPlainArgsBuilder internal constructor() {
    private var groupName: String? = null

    private var projectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Unique name of a group within a project.
     */
    @JvmName("cxxleehsltrqoocj")
    public suspend fun groupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupName = mapped
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("iepmtstagcrsenfj")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("whpuddoorsbkvbul")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetGroupPlainArgs = GetGroupPlainArgs(
        groupName = groupName ?: throw PulumiNullFieldException("groupName"),
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
