@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetImportCollectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property importCollectorName Unique name of a Import collector within a project.
 * @property projectName Name of the Azure Migrate project.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 */
public data class GetImportCollectorPlainArgs(
    public val importCollectorName: String,
    public val projectName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetImportCollectorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetImportCollectorPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetImportCollectorPlainArgs.builder()
            .importCollectorName(importCollectorName.let({ args0 -> args0 }))
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetImportCollectorPlainArgs].
 */
@PulumiTagMarker
public class GetImportCollectorPlainArgsBuilder internal constructor() {
    private var importCollectorName: String? = null

    private var projectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Unique name of a Import collector within a project.
     */
    @JvmName("cqomrjrhtucjymuy")
    public suspend fun importCollectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.importCollectorName = mapped
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("xnfxvpfivnbogfcu")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("yjgbhjmqqdbimuww")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetImportCollectorPlainArgs = GetImportCollectorPlainArgs(
        importCollectorName = importCollectorName ?: throw PulumiNullFieldException("importCollectorName"),
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
