@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetImportCollectorsOperationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property importCollectorName Import collector ARM name
 * @property projectName Assessment Project Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetImportCollectorsOperationPlainArgs(
    public val importCollectorName: String,
    public val projectName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetImportCollectorsOperationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetImportCollectorsOperationPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetImportCollectorsOperationPlainArgs.builder()
            .importCollectorName(importCollectorName.let({ args0 -> args0 }))
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetImportCollectorsOperationPlainArgs].
 */
@PulumiTagMarker
public class GetImportCollectorsOperationPlainArgsBuilder internal constructor() {
    private var importCollectorName: String? = null

    private var projectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Import collector ARM name
     */
    @JvmName("xinpuebglxhlxaau")
    public suspend fun importCollectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.importCollectorName = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("fbeihuogibuoltly")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kvgchtmewyowpcgt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetImportCollectorsOperationPlainArgs =
        GetImportCollectorsOperationPlainArgs(
            importCollectorName = importCollectorName ?: throw PulumiNullFieldException("importCollectorName"),
            projectName = projectName ?: throw PulumiNullFieldException("projectName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
