@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetMigrateProjectPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property migrateProjectName Name of the Azure Migrate project.
 * @property resourceGroupName Name of the Azure Resource Group that migrate project is part of.
 */
public data class GetMigrateProjectPlainArgs(
    public val migrateProjectName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetMigrateProjectPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetMigrateProjectPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetMigrateProjectPlainArgs.builder()
            .migrateProjectName(migrateProjectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMigrateProjectPlainArgs].
 */
@PulumiTagMarker
public class GetMigrateProjectPlainArgsBuilder internal constructor() {
    private var migrateProjectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("cyvpctkpuplyhkij")
    public suspend fun migrateProjectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.migrateProjectName = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that migrate project is part of.
     */
    @JvmName("tuvbiyhlyaccpowp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMigrateProjectPlainArgs = GetMigrateProjectPlainArgs(
        migrateProjectName = migrateProjectName ?: throw PulumiNullFieldException("migrateProjectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
