@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetModernizeProjectPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property modernizeProjectName Modernize project name.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 * @property subscriptionId Azure Subscription Id in which project was created.
 */
public data class GetModernizeProjectPlainArgs(
    public val modernizeProjectName: String,
    public val resourceGroupName: String,
    public val subscriptionId: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetModernizeProjectPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetModernizeProjectPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetModernizeProjectPlainArgs.builder()
            .modernizeProjectName(modernizeProjectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetModernizeProjectPlainArgs].
 */
@PulumiTagMarker
public class GetModernizeProjectPlainArgsBuilder internal constructor() {
    private var modernizeProjectName: String? = null

    private var resourceGroupName: String? = null

    private var subscriptionId: String? = null

    /**
     * @param value Modernize project name.
     */
    @JvmName("gfsjcnwdpcjmhwos")
    public suspend fun modernizeProjectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.modernizeProjectName = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("rfjcpfxikmswopug")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure Subscription Id in which project was created.
     */
    @JvmName("kuuuavbihjdpctwo")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.subscriptionId = mapped
    }

    internal fun build(): GetModernizeProjectPlainArgs = GetModernizeProjectPlainArgs(
        modernizeProjectName = modernizeProjectName ?: throw
            PulumiNullFieldException("modernizeProjectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        subscriptionId = subscriptionId,
    )
}
