@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetMoveResourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property moveCollectionName The Move Collection Name.
 * @property moveResourceName The Move Resource Name.
 * @property resourceGroupName The Resource Group Name.
 */
public data class GetMoveResourcePlainArgs(
    public val moveCollectionName: String,
    public val moveResourceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetMoveResourcePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetMoveResourcePlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetMoveResourcePlainArgs.builder()
            .moveCollectionName(moveCollectionName.let({ args0 -> args0 }))
            .moveResourceName(moveResourceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMoveResourcePlainArgs].
 */
@PulumiTagMarker
public class GetMoveResourcePlainArgsBuilder internal constructor() {
    private var moveCollectionName: String? = null

    private var moveResourceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Move Collection Name.
     */
    @JvmName("ofdsucrhfjnetlly")
    public suspend fun moveCollectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.moveCollectionName = mapped
    }

    /**
     * @param value The Move Resource Name.
     */
    @JvmName("cdtphhrwpyhkdaoo")
    public suspend fun moveResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.moveResourceName = mapped
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("dcvfxxyyulntnubl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMoveResourcePlainArgs = GetMoveResourcePlainArgs(
        moveCollectionName = moveCollectionName ?: throw PulumiNullFieldException("moveCollectionName"),
        moveResourceName = moveResourceName ?: throw PulumiNullFieldException("moveResourceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
