@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetPrivateEndpointConnectionProxyControllerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property migrateProjectName Name of the Azure Migrate project.
 * @property pecProxyName Private link proxy name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPrivateEndpointConnectionProxyControllerPlainArgs(
    public val migrateProjectName: String,
    public val pecProxyName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetPrivateEndpointConnectionProxyControllerPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.migrate.inputs.GetPrivateEndpointConnectionProxyControllerPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetPrivateEndpointConnectionProxyControllerPlainArgs.builder()
            .migrateProjectName(migrateProjectName.let({ args0 -> args0 }))
            .pecProxyName(pecProxyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateEndpointConnectionProxyControllerPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateEndpointConnectionProxyControllerPlainArgsBuilder internal constructor() {
    private var migrateProjectName: String? = null

    private var pecProxyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("aiqrlqbehxwisrjy")
    public suspend fun migrateProjectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.migrateProjectName = mapped
    }

    /**
     * @param value Private link proxy name.
     */
    @JvmName("lpylflrpfqounadx")
    public suspend fun pecProxyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.pecProxyName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iifqvdeddjwregmf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateEndpointConnectionProxyControllerPlainArgs =
        GetPrivateEndpointConnectionProxyControllerPlainArgs(
            migrateProjectName = migrateProjectName ?: throw PulumiNullFieldException("migrateProjectName"),
            pecProxyName = pecProxyName ?: throw PulumiNullFieldException("pecProxyName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
