@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GmsaAuthenticationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Class for GMSA authentication details to configure Active Directory connectivity.
 * @property adDomainControllerDns Gets or sets the list of dns server that can resolve the Active Directory Domain Name/Address.
 * @property adDomainFqdn Gets or sets the FQDN of the Active Directory Domain. For e.g. 'contoso.local', 'fareast.corp.microsoft.com' etc.
 * @property akvProperties
 * @property domainAdminPassword Gets or sets the password of the user specified by RestApi.Controllers.V2022_05_01_preview.Models.WorkloadDeployment.Gmsa.GmsaAuthenticationProperties.DomainAdminUsername.
 * @property domainAdminUsername Gets or sets the name of the user having admin rights on the Active Directory Domain Controller.
 * @property domainControllerAddress Gets or sets the address of the Active Directory Domain Controller running Domain Services.
 * @property gmsaAccountName Gets or sets the name to be used for GMSA.
 * @property gmsaUserPassword Gets or sets the password of the user specified by RestApi.Controllers.V2022_05_01_preview.Models.WorkloadDeployment.Gmsa.GmsaAuthenticationProperties.GmsaUsername.
 * @property gmsaUsername Gets or sets username of the user having authorization to access GMSA on Active Directory.
 */
public data class GmsaAuthenticationPropertiesArgs(
    public val adDomainControllerDns: Output<String>? = null,
    public val adDomainFqdn: Output<String>? = null,
    public val akvProperties: Output<KeyVaultSecretStorePropertiesArgs>? = null,
    public val domainAdminPassword: Output<String>? = null,
    public val domainAdminUsername: Output<String>? = null,
    public val domainControllerAddress: Output<String>? = null,
    public val gmsaAccountName: Output<String>? = null,
    public val gmsaUserPassword: Output<String>? = null,
    public val gmsaUsername: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GmsaAuthenticationPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GmsaAuthenticationPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.GmsaAuthenticationPropertiesArgs.builder()
            .adDomainControllerDns(adDomainControllerDns?.applyValue({ args0 -> args0 }))
            .adDomainFqdn(adDomainFqdn?.applyValue({ args0 -> args0 }))
            .akvProperties(akvProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .domainAdminPassword(domainAdminPassword?.applyValue({ args0 -> args0 }))
            .domainAdminUsername(domainAdminUsername?.applyValue({ args0 -> args0 }))
            .domainControllerAddress(domainControllerAddress?.applyValue({ args0 -> args0 }))
            .gmsaAccountName(gmsaAccountName?.applyValue({ args0 -> args0 }))
            .gmsaUserPassword(gmsaUserPassword?.applyValue({ args0 -> args0 }))
            .gmsaUsername(gmsaUsername?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GmsaAuthenticationPropertiesArgs].
 */
@PulumiTagMarker
public class GmsaAuthenticationPropertiesArgsBuilder internal constructor() {
    private var adDomainControllerDns: Output<String>? = null

    private var adDomainFqdn: Output<String>? = null

    private var akvProperties: Output<KeyVaultSecretStorePropertiesArgs>? = null

    private var domainAdminPassword: Output<String>? = null

    private var domainAdminUsername: Output<String>? = null

    private var domainControllerAddress: Output<String>? = null

    private var gmsaAccountName: Output<String>? = null

    private var gmsaUserPassword: Output<String>? = null

    private var gmsaUsername: Output<String>? = null

    /**
     * @param value Gets or sets the list of dns server that can resolve the Active Directory Domain Name/Address.
     */
    @JvmName("msrirgnssrtrjhvh")
    public suspend fun adDomainControllerDns(`value`: Output<String>) {
        this.adDomainControllerDns = value
    }

    /**
     * @param value Gets or sets the FQDN of the Active Directory Domain. For e.g. 'contoso.local', 'fareast.corp.microsoft.com' etc.
     */
    @JvmName("narblxktmgauecnv")
    public suspend fun adDomainFqdn(`value`: Output<String>) {
        this.adDomainFqdn = value
    }

    /**
     * @param value
     */
    @JvmName("yuqmikpkrmipbrva")
    public suspend fun akvProperties(`value`: Output<KeyVaultSecretStorePropertiesArgs>) {
        this.akvProperties = value
    }

    /**
     * @param value Gets or sets the password of the user specified by RestApi.Controllers.V2022_05_01_preview.Models.WorkloadDeployment.Gmsa.GmsaAuthenticationProperties.DomainAdminUsername.
     */
    @JvmName("kasoeoomcovxbprk")
    public suspend fun domainAdminPassword(`value`: Output<String>) {
        this.domainAdminPassword = value
    }

    /**
     * @param value Gets or sets the name of the user having admin rights on the Active Directory Domain Controller.
     */
    @JvmName("gvgbmgncsfekpmad")
    public suspend fun domainAdminUsername(`value`: Output<String>) {
        this.domainAdminUsername = value
    }

    /**
     * @param value Gets or sets the address of the Active Directory Domain Controller running Domain Services.
     */
    @JvmName("rgubuxujqrxqdvua")
    public suspend fun domainControllerAddress(`value`: Output<String>) {
        this.domainControllerAddress = value
    }

    /**
     * @param value Gets or sets the name to be used for GMSA.
     */
    @JvmName("dkwnavdprglbyfki")
    public suspend fun gmsaAccountName(`value`: Output<String>) {
        this.gmsaAccountName = value
    }

    /**
     * @param value Gets or sets the password of the user specified by RestApi.Controllers.V2022_05_01_preview.Models.WorkloadDeployment.Gmsa.GmsaAuthenticationProperties.GmsaUsername.
     */
    @JvmName("estiiyvyjujwlopv")
    public suspend fun gmsaUserPassword(`value`: Output<String>) {
        this.gmsaUserPassword = value
    }

    /**
     * @param value Gets or sets username of the user having authorization to access GMSA on Active Directory.
     */
    @JvmName("bbhtrpvodcvjjbjk")
    public suspend fun gmsaUsername(`value`: Output<String>) {
        this.gmsaUsername = value
    }

    /**
     * @param value Gets or sets the list of dns server that can resolve the Active Directory Domain Name/Address.
     */
    @JvmName("oxpgeoistduifdjh")
    public suspend fun adDomainControllerDns(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adDomainControllerDns = mapped
    }

    /**
     * @param value Gets or sets the FQDN of the Active Directory Domain. For e.g. 'contoso.local', 'fareast.corp.microsoft.com' etc.
     */
    @JvmName("jarlsmdxgbljvywc")
    public suspend fun adDomainFqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adDomainFqdn = mapped
    }

    /**
     * @param value
     */
    @JvmName("bqdcjsvwtnytainq")
    public suspend fun akvProperties(`value`: KeyVaultSecretStorePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.akvProperties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vgmuijfyftblnxfw")
    public suspend
    fun akvProperties(argument: suspend KeyVaultSecretStorePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultSecretStorePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.akvProperties = mapped
    }

    /**
     * @param value Gets or sets the password of the user specified by RestApi.Controllers.V2022_05_01_preview.Models.WorkloadDeployment.Gmsa.GmsaAuthenticationProperties.DomainAdminUsername.
     */
    @JvmName("vnlrxnnbicpstqch")
    public suspend fun domainAdminPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainAdminPassword = mapped
    }

    /**
     * @param value Gets or sets the name of the user having admin rights on the Active Directory Domain Controller.
     */
    @JvmName("ohaibctxjhqjpsvv")
    public suspend fun domainAdminUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainAdminUsername = mapped
    }

    /**
     * @param value Gets or sets the address of the Active Directory Domain Controller running Domain Services.
     */
    @JvmName("vjcltdvhccosxttp")
    public suspend fun domainControllerAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainControllerAddress = mapped
    }

    /**
     * @param value Gets or sets the name to be used for GMSA.
     */
    @JvmName("wurloogpqgsatokk")
    public suspend fun gmsaAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gmsaAccountName = mapped
    }

    /**
     * @param value Gets or sets the password of the user specified by RestApi.Controllers.V2022_05_01_preview.Models.WorkloadDeployment.Gmsa.GmsaAuthenticationProperties.GmsaUsername.
     */
    @JvmName("nbdsijspwgekxcff")
    public suspend fun gmsaUserPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gmsaUserPassword = mapped
    }

    /**
     * @param value Gets or sets username of the user having authorization to access GMSA on Active Directory.
     */
    @JvmName("mcoikvvjaptrlkvx")
    public suspend fun gmsaUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gmsaUsername = mapped
    }

    internal fun build(): GmsaAuthenticationPropertiesArgs = GmsaAuthenticationPropertiesArgs(
        adDomainControllerDns = adDomainControllerDns,
        adDomainFqdn = adDomainFqdn,
        akvProperties = akvProperties,
        domainAdminPassword = domainAdminPassword,
        domainAdminUsername = domainAdminUsername,
        domainControllerAddress = domainControllerAddress,
        gmsaAccountName = gmsaAccountName,
        gmsaUserPassword = gmsaUserPassword,
        gmsaUsername = gmsaUsername,
    )
}
