@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.IISAKSWorkloadDeploymentModelCustomPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * IIS workload instance model custom properties.
 * @property iisAksWorkloadDeploymentProperties IIS AKS workload deployment.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'IISAKSWorkloadDeploymentModelCustomProperties'.
 */
public data class IISAKSWorkloadDeploymentModelCustomPropertiesArgs(
    public val iisAksWorkloadDeploymentProperties: Output<IISAKSWorkloadDeploymentArgs>? = null,
    public val instanceType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.IISAKSWorkloadDeploymentModelCustomPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.migrate.inputs.IISAKSWorkloadDeploymentModelCustomPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.IISAKSWorkloadDeploymentModelCustomPropertiesArgs.builder()
            .iisAksWorkloadDeploymentProperties(
                iisAksWorkloadDeploymentProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .instanceType(instanceType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IISAKSWorkloadDeploymentModelCustomPropertiesArgs].
 */
@PulumiTagMarker
public class IISAKSWorkloadDeploymentModelCustomPropertiesArgsBuilder internal constructor() {
    private var iisAksWorkloadDeploymentProperties: Output<IISAKSWorkloadDeploymentArgs>? = null

    private var instanceType: Output<String>? = null

    /**
     * @param value IIS AKS workload deployment.
     */
    @JvmName("narkruwjgyfffoiy")
    public suspend
    fun iisAksWorkloadDeploymentProperties(`value`: Output<IISAKSWorkloadDeploymentArgs>) {
        this.iisAksWorkloadDeploymentProperties = value
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'IISAKSWorkloadDeploymentModelCustomProperties'.
     */
    @JvmName("dtvnsdfrjdehxvdo")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value IIS AKS workload deployment.
     */
    @JvmName("eylrdhepireustme")
    public suspend fun iisAksWorkloadDeploymentProperties(`value`: IISAKSWorkloadDeploymentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iisAksWorkloadDeploymentProperties = mapped
    }

    /**
     * @param argument IIS AKS workload deployment.
     */
    @JvmName("lpainkvexlwniuph")
    public suspend
    fun iisAksWorkloadDeploymentProperties(argument: suspend IISAKSWorkloadDeploymentArgsBuilder.() -> Unit) {
        val toBeMapped = IISAKSWorkloadDeploymentArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.iisAksWorkloadDeploymentProperties = mapped
    }

    /**
     * @param value Gets or sets the instance type.
     * Expected value is 'IISAKSWorkloadDeploymentModelCustomProperties'.
     */
    @JvmName("guhrwsqohuwrpwea")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    internal fun build(): IISAKSWorkloadDeploymentModelCustomPropertiesArgs =
        IISAKSWorkloadDeploymentModelCustomPropertiesArgs(
            iisAksWorkloadDeploymentProperties = iisAksWorkloadDeploymentProperties,
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        )
}
