@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.ImportCollectorPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property discoverySiteId
 */
public data class ImportCollectorPropertiesArgs(
    public val discoverySiteId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.ImportCollectorPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.ImportCollectorPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.ImportCollectorPropertiesArgs.builder()
            .discoverySiteId(discoverySiteId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImportCollectorPropertiesArgs].
 */
@PulumiTagMarker
public class ImportCollectorPropertiesArgsBuilder internal constructor() {
    private var discoverySiteId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("lmrqtuudqdnauloe")
    public suspend fun discoverySiteId(`value`: Output<String>) {
        this.discoverySiteId = value
    }

    /**
     * @param value
     */
    @JvmName("sasacglpfvnjuidq")
    public suspend fun discoverySiteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoverySiteId = mapped
    }

    internal fun build(): ImportCollectorPropertiesArgs = ImportCollectorPropertiesArgs(
        discoverySiteId = discoverySiteId,
    )
}
