@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.KeyVaultSecretStorePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property keyvaultName
 * @property managedIdentityProperties
 * @property resourceGroup
 * @property secretStoreId
 * @property subscriptionId
 * @property tenantId
 */
public data class KeyVaultSecretStorePropertiesArgs(
    public val keyvaultName: Output<String>? = null,
    public val managedIdentityProperties: Output<ManagedIdentityPropertiesArgs>? = null,
    public val resourceGroup: Output<String>? = null,
    public val secretStoreId: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.KeyVaultSecretStorePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.KeyVaultSecretStorePropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.KeyVaultSecretStorePropertiesArgs.builder()
            .keyvaultName(keyvaultName?.applyValue({ args0 -> args0 }))
            .managedIdentityProperties(
                managedIdentityProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .secretStoreId(secretStoreId?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultSecretStorePropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultSecretStorePropertiesArgsBuilder internal constructor() {
    private var keyvaultName: Output<String>? = null

    private var managedIdentityProperties: Output<ManagedIdentityPropertiesArgs>? = null

    private var resourceGroup: Output<String>? = null

    private var secretStoreId: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ubibxrmgyqmhwyda")
    public suspend fun keyvaultName(`value`: Output<String>) {
        this.keyvaultName = value
    }

    /**
     * @param value
     */
    @JvmName("muqjooojdixtsslg")
    public suspend fun managedIdentityProperties(`value`: Output<ManagedIdentityPropertiesArgs>) {
        this.managedIdentityProperties = value
    }

    /**
     * @param value
     */
    @JvmName("uegvnetyxcknqxjm")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value
     */
    @JvmName("tgnnwdamqdynteis")
    public suspend fun secretStoreId(`value`: Output<String>) {
        this.secretStoreId = value
    }

    /**
     * @param value
     */
    @JvmName("urgguowjdkvvxelv")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value
     */
    @JvmName("haxxlpmlpxtkqiav")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value
     */
    @JvmName("dkmldawvbqvxbxmx")
    public suspend fun keyvaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyvaultName = mapped
    }

    /**
     * @param value
     */
    @JvmName("ljirphcaawlmjubl")
    public suspend fun managedIdentityProperties(`value`: ManagedIdentityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedIdentityProperties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tnabeetuqscoknow")
    public suspend
    fun managedIdentityProperties(argument: suspend ManagedIdentityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedIdentityProperties = mapped
    }

    /**
     * @param value
     */
    @JvmName("fvlnqksgmtcpdjql")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value
     */
    @JvmName("rumhmbfbwqkvlcoo")
    public suspend fun secretStoreId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretStoreId = mapped
    }

    /**
     * @param value
     */
    @JvmName("aewtfoicfyjtlmkw")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value
     */
    @JvmName("qtbyoulhbfkhclif")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): KeyVaultSecretStorePropertiesArgs = KeyVaultSecretStorePropertiesArgs(
        keyvaultName = keyvaultName,
        managedIdentityProperties = managedIdentityProperties,
        resourceGroup = resourceGroup,
        secretStoreId = secretStoreId,
        subscriptionId = subscriptionId,
        tenantId = tenantId,
    )
}
