@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.ModernizeProjectModelPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * ModernizeProject properties.
 * @property migrationConfiguration MigrationConfiguration properties.
 */
public data class ModernizeProjectModelPropertiesArgs(
    public val migrationConfiguration: Output<MigrationConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.ModernizeProjectModelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.ModernizeProjectModelPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.ModernizeProjectModelPropertiesArgs.builder()
            .migrationConfiguration(
                migrationConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ModernizeProjectModelPropertiesArgs].
 */
@PulumiTagMarker
public class ModernizeProjectModelPropertiesArgsBuilder internal constructor() {
    private var migrationConfiguration: Output<MigrationConfigurationArgs>? = null

    /**
     * @param value MigrationConfiguration properties.
     */
    @JvmName("mxeysmfnoufmbkkt")
    public suspend fun migrationConfiguration(`value`: Output<MigrationConfigurationArgs>) {
        this.migrationConfiguration = value
    }

    /**
     * @param value MigrationConfiguration properties.
     */
    @JvmName("uuybdpnspqwwwyex")
    public suspend fun migrationConfiguration(`value`: MigrationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationConfiguration = mapped
    }

    /**
     * @param argument MigrationConfiguration properties.
     */
    @JvmName("csjetvkjgvpiblhy")
    public suspend
    fun migrationConfiguration(argument: suspend MigrationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = MigrationConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.migrationConfiguration = mapped
    }

    internal fun build(): ModernizeProjectModelPropertiesArgs = ModernizeProjectModelPropertiesArgs(
        migrationConfiguration = migrationConfiguration,
    )
}
