@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.ResourceGroupResourceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the resource group resource settings.
 * @property resourceType The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
 * Expected value is 'resourceGroups'.
 * @property targetResourceGroupName Gets or sets the target resource group name.
 * @property targetResourceName Gets or sets the target Resource name.
 */
public data class ResourceGroupResourceSettingsArgs(
    public val resourceType: Output<String>,
    public val targetResourceGroupName: Output<String>? = null,
    public val targetResourceName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.ResourceGroupResourceSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.ResourceGroupResourceSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.ResourceGroupResourceSettingsArgs.builder()
            .resourceType(resourceType.applyValue({ args0 -> args0 }))
            .targetResourceGroupName(targetResourceGroupName?.applyValue({ args0 -> args0 }))
            .targetResourceName(targetResourceName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceGroupResourceSettingsArgs].
 */
@PulumiTagMarker
public class ResourceGroupResourceSettingsArgsBuilder internal constructor() {
    private var resourceType: Output<String>? = null

    private var targetResourceGroupName: Output<String>? = null

    private var targetResourceName: Output<String>? = null

    /**
     * @param value The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
     * Expected value is 'resourceGroups'.
     */
    @JvmName("iiowvysxpvvvrfhh")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Gets or sets the target resource group name.
     */
    @JvmName("ydgtvxrnqjymeqqe")
    public suspend fun targetResourceGroupName(`value`: Output<String>) {
        this.targetResourceGroupName = value
    }

    /**
     * @param value Gets or sets the target Resource name.
     */
    @JvmName("ikwsygsmpotvmywp")
    public suspend fun targetResourceName(`value`: Output<String>) {
        this.targetResourceName = value
    }

    /**
     * @param value The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
     * Expected value is 'resourceGroups'.
     */
    @JvmName("daheopisftfocmtt")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Gets or sets the target resource group name.
     */
    @JvmName("ykuyumbkpradibiw")
    public suspend fun targetResourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the target Resource name.
     */
    @JvmName("bcwfnashinxidirj")
    public suspend fun targetResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetResourceName = mapped
    }

    internal fun build(): ResourceGroupResourceSettingsArgs = ResourceGroupResourceSettingsArgs(
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
        targetResourceGroupName = targetResourceGroupName,
        targetResourceName = targetResourceName ?: throw PulumiNullFieldException("targetResourceName"),
    )
}
