@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.SolutionPropertiesArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.CleanupState
import com.pulumi.azurenative.migrate.kotlin.enums.Goal
import com.pulumi.azurenative.migrate.kotlin.enums.Purpose
import com.pulumi.azurenative.migrate.kotlin.enums.Status
import com.pulumi.azurenative.migrate.kotlin.enums.Tool
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Class for solution properties.
 * @property cleanupState Gets or sets the cleanup state of the solution.
 * @property details Gets or sets the details of the solution.
 * @property goal Gets or sets the goal of the solution.
 * @property purpose Gets or sets the purpose of the solution.
 * @property status Gets or sets the current status of the solution.
 * @property tool Gets or sets the tool being used in the solution.
 */
public data class SolutionPropertiesArgs(
    public val cleanupState: Output<Either<String, CleanupState>>? = null,
    public val details: Output<SolutionDetailsArgs>? = null,
    public val goal: Output<Either<String, Goal>>? = null,
    public val purpose: Output<Either<String, Purpose>>? = null,
    public val status: Output<Either<String, Status>>? = null,
    public val tool: Output<Either<String, Tool>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.SolutionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.SolutionPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.SolutionPropertiesArgs.builder()
            .cleanupState(
                cleanupState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .details(details?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .goal(
                goal?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .purpose(
                purpose?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tool(
                tool?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SolutionPropertiesArgs].
 */
@PulumiTagMarker
public class SolutionPropertiesArgsBuilder internal constructor() {
    private var cleanupState: Output<Either<String, CleanupState>>? = null

    private var details: Output<SolutionDetailsArgs>? = null

    private var goal: Output<Either<String, Goal>>? = null

    private var purpose: Output<Either<String, Purpose>>? = null

    private var status: Output<Either<String, Status>>? = null

    private var tool: Output<Either<String, Tool>>? = null

    /**
     * @param value Gets or sets the cleanup state of the solution.
     */
    @JvmName("upwwghcnqtpnmsbj")
    public suspend fun cleanupState(`value`: Output<Either<String, CleanupState>>) {
        this.cleanupState = value
    }

    /**
     * @param value Gets or sets the details of the solution.
     */
    @JvmName("pupikdunrjtaoxav")
    public suspend fun details(`value`: Output<SolutionDetailsArgs>) {
        this.details = value
    }

    /**
     * @param value Gets or sets the goal of the solution.
     */
    @JvmName("xowfgqhobthixjct")
    public suspend fun goal(`value`: Output<Either<String, Goal>>) {
        this.goal = value
    }

    /**
     * @param value Gets or sets the purpose of the solution.
     */
    @JvmName("qmipydsxdjxgtqsy")
    public suspend fun purpose(`value`: Output<Either<String, Purpose>>) {
        this.purpose = value
    }

    /**
     * @param value Gets or sets the current status of the solution.
     */
    @JvmName("jaoapyyvgwncrtpn")
    public suspend fun status(`value`: Output<Either<String, Status>>) {
        this.status = value
    }

    /**
     * @param value Gets or sets the tool being used in the solution.
     */
    @JvmName("hukltaxqmtomnssr")
    public suspend fun tool(`value`: Output<Either<String, Tool>>) {
        this.tool = value
    }

    /**
     * @param value Gets or sets the cleanup state of the solution.
     */
    @JvmName("brfcqcybruuygwkm")
    public suspend fun cleanupState(`value`: Either<String, CleanupState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cleanupState = mapped
    }

    /**
     * @param value Gets or sets the cleanup state of the solution.
     */
    @JvmName("idticscxaifogvuv")
    public fun cleanupState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CleanupState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cleanupState = mapped
    }

    /**
     * @param value Gets or sets the cleanup state of the solution.
     */
    @JvmName("kjfnylughatkcrbe")
    public fun cleanupState(`value`: CleanupState) {
        val toBeMapped = Either.ofRight<String, CleanupState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cleanupState = mapped
    }

    /**
     * @param value Gets or sets the details of the solution.
     */
    @JvmName("msmhqtdshckwnkmg")
    public suspend fun details(`value`: SolutionDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.details = mapped
    }

    /**
     * @param argument Gets or sets the details of the solution.
     */
    @JvmName("xspqcpdvyaebskcx")
    public suspend fun details(argument: suspend SolutionDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = SolutionDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.details = mapped
    }

    /**
     * @param value Gets or sets the goal of the solution.
     */
    @JvmName("reehbneoejuntcdb")
    public suspend fun goal(`value`: Either<String, Goal>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.goal = mapped
    }

    /**
     * @param value Gets or sets the goal of the solution.
     */
    @JvmName("npwnxfvwqevdpipw")
    public fun goal(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Goal>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.goal = mapped
    }

    /**
     * @param value Gets or sets the goal of the solution.
     */
    @JvmName("kgvyidyreidtgyrb")
    public fun goal(`value`: Goal) {
        val toBeMapped = Either.ofRight<String, Goal>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.goal = mapped
    }

    /**
     * @param value Gets or sets the purpose of the solution.
     */
    @JvmName("mffhbqjngkcbbqee")
    public suspend fun purpose(`value`: Either<String, Purpose>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.purpose = mapped
    }

    /**
     * @param value Gets or sets the purpose of the solution.
     */
    @JvmName("jorkuevqvwshsscw")
    public fun purpose(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Purpose>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.purpose = mapped
    }

    /**
     * @param value Gets or sets the purpose of the solution.
     */
    @JvmName("htfmfrvoxjqwggwm")
    public fun purpose(`value`: Purpose) {
        val toBeMapped = Either.ofRight<String, Purpose>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.purpose = mapped
    }

    /**
     * @param value Gets or sets the current status of the solution.
     */
    @JvmName("lsrtrtxqqxdcjdxc")
    public suspend fun status(`value`: Either<String, Status>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Gets or sets the current status of the solution.
     */
    @JvmName("qgdskvakwjqbktcp")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Status>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Gets or sets the current status of the solution.
     */
    @JvmName("ynqedioduvhqnvjh")
    public fun status(`value`: Status) {
        val toBeMapped = Either.ofRight<String, Status>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Gets or sets the tool being used in the solution.
     */
    @JvmName("tochwqfvceiemkla")
    public suspend fun tool(`value`: Either<String, Tool>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tool = mapped
    }

    /**
     * @param value Gets or sets the tool being used in the solution.
     */
    @JvmName("kkcaucsankbcqggp")
    public fun tool(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Tool>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tool = mapped
    }

    /**
     * @param value Gets or sets the tool being used in the solution.
     */
    @JvmName("cgmmnnhikgbppbfg")
    public fun tool(`value`: Tool) {
        val toBeMapped = Either.ofRight<String, Tool>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tool = mapped
    }

    internal fun build(): SolutionPropertiesArgs = SolutionPropertiesArgs(
        cleanupState = cleanupState,
        details = details,
        goal = goal,
        purpose = purpose,
        status = status,
        tool = tool,
    )
}
