@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.VirtualNetworkResourceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Defines the virtual network resource settings.
 * @property addressSpace Gets or sets the address prefixes for the virtual network.
 * @property dnsServers Gets or sets DHCPOptions that contains an array of DNS servers available to VMs
 * deployed in the virtual network.
 * @property enableDdosProtection Gets or sets a value indicating whether gets or sets whether the
 * DDOS protection should be switched on.
 * @property resourceType The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
 * Expected value is 'Microsoft.Network/virtualNetworks'.
 * @property subnets Gets or sets List of subnets in a VirtualNetwork.
 * @property tags Gets or sets the Resource tags.
 * @property targetResourceGroupName Gets or sets the target resource group name.
 * @property targetResourceName Gets or sets the target Resource name.
 */
public data class VirtualNetworkResourceSettingsArgs(
    public val addressSpace: Output<List<String>>? = null,
    public val dnsServers: Output<List<String>>? = null,
    public val enableDdosProtection: Output<Boolean>? = null,
    public val resourceType: Output<String>,
    public val subnets: Output<List<SubnetResourceSettingsArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetResourceGroupName: Output<String>? = null,
    public val targetResourceName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.VirtualNetworkResourceSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.VirtualNetworkResourceSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.VirtualNetworkResourceSettingsArgs.builder()
            .addressSpace(addressSpace?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .dnsServers(dnsServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .enableDdosProtection(enableDdosProtection?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType.applyValue({ args0 -> args0 }))
            .subnets(
                subnets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetResourceGroupName(targetResourceGroupName?.applyValue({ args0 -> args0 }))
            .targetResourceName(targetResourceName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkResourceSettingsArgs].
 */
@PulumiTagMarker
public class VirtualNetworkResourceSettingsArgsBuilder internal constructor() {
    private var addressSpace: Output<List<String>>? = null

    private var dnsServers: Output<List<String>>? = null

    private var enableDdosProtection: Output<Boolean>? = null

    private var resourceType: Output<String>? = null

    private var subnets: Output<List<SubnetResourceSettingsArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetResourceGroupName: Output<String>? = null

    private var targetResourceName: Output<String>? = null

    /**
     * @param value Gets or sets the address prefixes for the virtual network.
     */
    @JvmName("khcasrgxihyhpslb")
    public suspend fun addressSpace(`value`: Output<List<String>>) {
        this.addressSpace = value
    }

    @JvmName("aephcrkdulvyukdg")
    public suspend fun addressSpace(vararg values: Output<String>) {
        this.addressSpace = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the address prefixes for the virtual network.
     */
    @JvmName("mqscxhgdtbnrqhag")
    public suspend fun addressSpace(values: List<Output<String>>) {
        this.addressSpace = Output.all(values)
    }

    /**
     * @param value Gets or sets DHCPOptions that contains an array of DNS servers available to VMs
     * deployed in the virtual network.
     */
    @JvmName("odvgeyfrsiwwbbtp")
    public suspend fun dnsServers(`value`: Output<List<String>>) {
        this.dnsServers = value
    }

    @JvmName("oymxqlapdkpkwlry")
    public suspend fun dnsServers(vararg values: Output<String>) {
        this.dnsServers = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets DHCPOptions that contains an array of DNS servers available to VMs
     * deployed in the virtual network.
     */
    @JvmName("wtnejofaacwhdrck")
    public suspend fun dnsServers(values: List<Output<String>>) {
        this.dnsServers = Output.all(values)
    }

    /**
     * @param value Gets or sets a value indicating whether gets or sets whether the
     * DDOS protection should be switched on.
     */
    @JvmName("xglruvehogqcvggr")
    public suspend fun enableDdosProtection(`value`: Output<Boolean>) {
        this.enableDdosProtection = value
    }

    /**
     * @param value The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
     * Expected value is 'Microsoft.Network/virtualNetworks'.
     */
    @JvmName("nfcbqjqaxxqrfqot")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Gets or sets List of subnets in a VirtualNetwork.
     */
    @JvmName("rwyddncjfvgbvlsy")
    public suspend fun subnets(`value`: Output<List<SubnetResourceSettingsArgs>>) {
        this.subnets = value
    }

    @JvmName("mhciedwxfnpigcbo")
    public suspend fun subnets(vararg values: Output<SubnetResourceSettingsArgs>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets List of subnets in a VirtualNetwork.
     */
    @JvmName("ybedbetwnggdtwfw")
    public suspend fun subnets(values: List<Output<SubnetResourceSettingsArgs>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("uxxmkgipacstgnvs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Gets or sets the target resource group name.
     */
    @JvmName("tuqpeklctbodvvvu")
    public suspend fun targetResourceGroupName(`value`: Output<String>) {
        this.targetResourceGroupName = value
    }

    /**
     * @param value Gets or sets the target Resource name.
     */
    @JvmName("qcupgcypiphkdync")
    public suspend fun targetResourceName(`value`: Output<String>) {
        this.targetResourceName = value
    }

    /**
     * @param value Gets or sets the address prefixes for the virtual network.
     */
    @JvmName("xvnjdrolicrwplex")
    public suspend fun addressSpace(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressSpace = mapped
    }

    /**
     * @param values Gets or sets the address prefixes for the virtual network.
     */
    @JvmName("bxrrjckyvlwnxcwa")
    public suspend fun addressSpace(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressSpace = mapped
    }

    /**
     * @param value Gets or sets DHCPOptions that contains an array of DNS servers available to VMs
     * deployed in the virtual network.
     */
    @JvmName("esmsrhjpjoflonim")
    public suspend fun dnsServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param values Gets or sets DHCPOptions that contains an array of DNS servers available to VMs
     * deployed in the virtual network.
     */
    @JvmName("uaprnkehmgqatgbe")
    public suspend fun dnsServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether gets or sets whether the
     * DDOS protection should be switched on.
     */
    @JvmName("tyigxdobpheciwej")
    public suspend fun enableDdosProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDdosProtection = mapped
    }

    /**
     * @param value The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
     * Expected value is 'Microsoft.Network/virtualNetworks'.
     */
    @JvmName("amxpmxatdvqbmvec")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Gets or sets List of subnets in a VirtualNetwork.
     */
    @JvmName("ubjceuthnqkxfsyp")
    public suspend fun subnets(`value`: List<SubnetResourceSettingsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param argument Gets or sets List of subnets in a VirtualNetwork.
     */
    @JvmName("dvsmphkirmqtmssj")
    public suspend fun subnets(argument: List<suspend SubnetResourceSettingsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SubnetResourceSettingsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param argument Gets or sets List of subnets in a VirtualNetwork.
     */
    @JvmName("jbddqptxyfejqlmx")
    public suspend fun subnets(
        vararg
        argument: suspend SubnetResourceSettingsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SubnetResourceSettingsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param argument Gets or sets List of subnets in a VirtualNetwork.
     */
    @JvmName("ubqodvgjfsnffnvp")
    public suspend fun subnets(argument: suspend SubnetResourceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubnetResourceSettingsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.subnets = mapped
    }

    /**
     * @param values Gets or sets List of subnets in a VirtualNetwork.
     */
    @JvmName("xgafjttpexxybvts")
    public suspend fun subnets(vararg values: SubnetResourceSettingsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("ghqpvvuluikfmwmw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the Resource tags.
     */
    @JvmName("cpvejxwbwyupraaf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Gets or sets the target resource group name.
     */
    @JvmName("tscevvyojonhwbbu")
    public suspend fun targetResourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the target Resource name.
     */
    @JvmName("jtuojfyjyclghmxt")
    public suspend fun targetResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetResourceName = mapped
    }

    internal fun build(): VirtualNetworkResourceSettingsArgs = VirtualNetworkResourceSettingsArgs(
        addressSpace = addressSpace,
        dnsServers = dnsServers,
        enableDdosProtection = enableDdosProtection,
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
        subnets = subnets,
        tags = tags,
        targetResourceGroupName = targetResourceGroupName,
        targetResourceName = targetResourceName ?: throw PulumiNullFieldException("targetResourceName"),
    )
}
