@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.WebApplicationDirectoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * WebApplication directory structure.
 * @property isEditable Gets or sets a value indicating whether the directory object is editable.
 * True when the directory is added as an optional directory, false when discovery is done
 * manually.
 * @property sourcePaths Gets or sets the paths of the directory on the source machine.
 * @property sourceSize Gets or sets the size of the directory on the source machine.
 * @property storageProfile Storage profile for the directory on the target container.
 */
public data class WebApplicationDirectoryArgs(
    public val isEditable: Output<Boolean>? = null,
    public val sourcePaths: Output<List<String>>? = null,
    public val sourceSize: Output<String>? = null,
    public val storageProfile: Output<TargetStorageProfileArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.WebApplicationDirectoryArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.WebApplicationDirectoryArgs =
        com.pulumi.azurenative.migrate.inputs.WebApplicationDirectoryArgs.builder()
            .isEditable(isEditable?.applyValue({ args0 -> args0 }))
            .sourcePaths(sourcePaths?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceSize(sourceSize?.applyValue({ args0 -> args0 }))
            .storageProfile(
                storageProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebApplicationDirectoryArgs].
 */
@PulumiTagMarker
public class WebApplicationDirectoryArgsBuilder internal constructor() {
    private var isEditable: Output<Boolean>? = null

    private var sourcePaths: Output<List<String>>? = null

    private var sourceSize: Output<String>? = null

    private var storageProfile: Output<TargetStorageProfileArgs>? = null

    /**
     * @param value Gets or sets a value indicating whether the directory object is editable.
     * True when the directory is added as an optional directory, false when discovery is done
     * manually.
     */
    @JvmName("sasagngpkadjfpcg")
    public suspend fun isEditable(`value`: Output<Boolean>) {
        this.isEditable = value
    }

    /**
     * @param value Gets or sets the paths of the directory on the source machine.
     */
    @JvmName("xyfmjopuorqygadk")
    public suspend fun sourcePaths(`value`: Output<List<String>>) {
        this.sourcePaths = value
    }

    @JvmName("xxhyqyyetrkmprsa")
    public suspend fun sourcePaths(vararg values: Output<String>) {
        this.sourcePaths = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the paths of the directory on the source machine.
     */
    @JvmName("uisgfpcorjvecygq")
    public suspend fun sourcePaths(values: List<Output<String>>) {
        this.sourcePaths = Output.all(values)
    }

    /**
     * @param value Gets or sets the size of the directory on the source machine.
     */
    @JvmName("siqvrguxoiptmtna")
    public suspend fun sourceSize(`value`: Output<String>) {
        this.sourceSize = value
    }

    /**
     * @param value Storage profile for the directory on the target container.
     */
    @JvmName("vihpqolxutxgxnld")
    public suspend fun storageProfile(`value`: Output<TargetStorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value Gets or sets a value indicating whether the directory object is editable.
     * True when the directory is added as an optional directory, false when discovery is done
     * manually.
     */
    @JvmName("jeyyjevsgkkjogac")
    public suspend fun isEditable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEditable = mapped
    }

    /**
     * @param value Gets or sets the paths of the directory on the source machine.
     */
    @JvmName("rswpckcgwkdggqmn")
    public suspend fun sourcePaths(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePaths = mapped
    }

    /**
     * @param values Gets or sets the paths of the directory on the source machine.
     */
    @JvmName("womjtegpchkdyoth")
    public suspend fun sourcePaths(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePaths = mapped
    }

    /**
     * @param value Gets or sets the size of the directory on the source machine.
     */
    @JvmName("tfkxnrltaurqqbwl")
    public suspend fun sourceSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceSize = mapped
    }

    /**
     * @param value Storage profile for the directory on the target container.
     */
    @JvmName("gqvnunfxkjxlviwn")
    public suspend fun storageProfile(`value`: TargetStorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument Storage profile for the directory on the target container.
     */
    @JvmName("aqgtdujfetcakfnt")
    public suspend fun storageProfile(argument: suspend TargetStorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = TargetStorageProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    internal fun build(): WebApplicationDirectoryArgs = WebApplicationDirectoryArgs(
        isEditable = isEditable,
        sourcePaths = sourcePaths,
        sourceSize = sourceSize,
        storageProfile = storageProfile,
    )
}
