@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ID and Key for Migration Project.
 * @property workspaceId ID of Migration Project.
 * @property workspaceKey Key of Migration Project.
 */
public data class GetProjectKeysResult(
    public val workspaceId: String,
    public val workspaceKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetProjectKeysResult):
            GetProjectKeysResult = GetProjectKeysResult(
            workspaceId = javaType.workspaceId(),
            workspaceKey = javaType.workspaceKey(),
        )
    }
}
