@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createdAt Gets or sets the timestamp of resource creation (UTC).
 * @property createdBy Gets or sets identity that created the resource.
 * @property createdByType Gets or sets the type of identity that created the resource: user, application,
 * managedIdentity.
 * @property lastModifiedAt Gets or sets the timestamp of resource last modification (UTC).
 * @property lastModifiedBy Gets or sets the identity that last modified the resource.
 * @property lastModifiedByType Gets or sets the type of identity that last modified the resource: user, application,
 * managedIdentity.
 */
public data class ModernizeProjectModelResponseSystemData(
    public val createdAt: String? = null,
    public val createdBy: String? = null,
    public val createdByType: String? = null,
    public val lastModifiedAt: String? = null,
    public val lastModifiedBy: String? = null,
    public val lastModifiedByType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.ModernizeProjectModelResponseSystemData):
            ModernizeProjectModelResponseSystemData = ModernizeProjectModelResponseSystemData(
            createdAt = javaType.createdAt().map({ args0 -> args0 }).orElse(null),
            createdBy = javaType.createdBy().map({ args0 -> args0 }).orElse(null),
            createdByType = javaType.createdByType().map({ args0 -> args0 }).orElse(null),
            lastModifiedAt = javaType.lastModifiedAt().map({ args0 -> args0 }).orElse(null),
            lastModifiedBy = javaType.lastModifiedBy().map({ args0 -> args0 }).orElse(null),
            lastModifiedByType = javaType.lastModifiedByType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
