@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the move collection properties.
 * @property errors Defines the move collection errors.
 * @property provisioningState Defines the provisioning states.
 * @property sourceRegion Gets or sets the source region.
 * @property targetRegion Gets or sets the target region.
 * @property version Gets or sets the version of move collection.
 */
public data class MoveCollectionPropertiesResponse(
    public val errors: MoveCollectionPropertiesResponseErrors,
    public val provisioningState: String,
    public val sourceRegion: String,
    public val targetRegion: String,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.MoveCollectionPropertiesResponse):
            MoveCollectionPropertiesResponse = MoveCollectionPropertiesResponse(
            errors = javaType.errors().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.MoveCollectionPropertiesResponseErrors.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
            sourceRegion = javaType.sourceRegion(),
            targetRegion = javaType.targetRegion(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
