@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the dependency of the move resource.
 * @property automaticResolution Defines the properties for automatic resolution.
 * @property dependencyType Defines the dependency type.
 * @property id Gets the source ARM ID of the dependent resource.
 * @property isOptional Gets or sets a value indicating whether the dependency is optional.
 * @property manualResolution Defines the properties for manual resolution.
 * @property resolutionStatus Gets the dependency resolution status.
 * @property resolutionType Defines the resolution type.
 */
public data class MoveResourceDependencyResponse(
    public val automaticResolution: AutomaticResolutionPropertiesResponse? = null,
    public val dependencyType: String? = null,
    public val id: String? = null,
    public val isOptional: String? = null,
    public val manualResolution: ManualResolutionPropertiesResponse? = null,
    public val resolutionStatus: String? = null,
    public val resolutionType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.MoveResourceDependencyResponse):
            MoveResourceDependencyResponse = MoveResourceDependencyResponse(
            automaticResolution = javaType.automaticResolution().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.AutomaticResolutionPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dependencyType = javaType.dependencyType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            isOptional = javaType.isOptional().map({ args0 -> args0 }).orElse(null),
            manualResolution = javaType.manualResolution().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.ManualResolutionPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resolutionStatus = javaType.resolutionStatus().map({ args0 -> args0 }).orElse(null),
            resolutionType = javaType.resolutionType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
