@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the move resource status.
 * @property errors An error response from the azure resource mover service.
 * @property jobStatus Defines the job status.
 * @property moveState Defines the MoveResource states.
 */
public data class MoveResourcePropertiesResponseMoveStatus(
    public val errors: MoveResourceErrorResponse? = null,
    public val jobStatus: JobStatusResponse? = null,
    public val moveState: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.MoveResourcePropertiesResponseMoveStatus):
            MoveResourcePropertiesResponseMoveStatus = MoveResourcePropertiesResponseMoveStatus(
            errors = javaType.errors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.MoveResourceErrorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            jobStatus = javaType.jobStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.JobStatusResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            moveState = javaType.moveState(),
        )
    }
}
