@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Project summary.
 * @property extendedSummary Extended summary.
 * @property instanceType Instance type.
 * @property lastSummaryRefreshedTime Last summary refresh time.
 * @property refreshSummaryState Refresh summary state.
 */
public data class ProjectSummaryResponse(
    public val extendedSummary: Map<String, String>? = null,
    public val instanceType: String,
    public val lastSummaryRefreshedTime: String? = null,
    public val refreshSummaryState: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.ProjectSummaryResponse):
            ProjectSummaryResponse = ProjectSummaryResponse(
            extendedSummary = javaType.extendedSummary().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            instanceType = javaType.instanceType(),
            lastSummaryRefreshedTime = javaType.lastSummaryRefreshedTime().map({ args0 -> args0 }).orElse(null),
            refreshSummaryState = javaType.refreshSummaryState().map({ args0 -> args0 }).orElse(null),
        )
    }
}
