@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Class representing the servers solution summary.
 * @property assessedCount Gets or sets the count of servers assessed.
 * @property discoveredCount Gets or sets the count of servers discovered.
 * @property instanceType Gets the Instance type.
 * Expected value is 'Servers'.
 * @property migratedCount Gets or sets the count of servers migrated.
 * @property replicatingCount Gets or sets the count of servers being replicated.
 * @property testMigratedCount Gets or sets the count of servers test migrated.
 */
public data class ServersSolutionSummaryResponse(
    public val assessedCount: Int? = null,
    public val discoveredCount: Int? = null,
    public val instanceType: String,
    public val migratedCount: Int? = null,
    public val replicatingCount: Int? = null,
    public val testMigratedCount: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.ServersSolutionSummaryResponse):
            ServersSolutionSummaryResponse = ServersSolutionSummaryResponse(
            assessedCount = javaType.assessedCount().map({ args0 -> args0 }).orElse(null),
            discoveredCount = javaType.discoveredCount().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType(),
            migratedCount = javaType.migratedCount().map({ args0 -> args0 }).orElse(null),
            replicatingCount = javaType.replicatingCount().map({ args0 -> args0 }).orElse(null),
            testMigratedCount = javaType.testMigratedCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
