@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the SQL Server resource settings.
 * @property resourceType The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
 * Expected value is 'Microsoft.Sql/servers'.
 * @property targetResourceGroupName Gets or sets the target resource group name.
 * @property targetResourceName Gets or sets the target Resource name.
 */
public data class SqlServerResourceSettingsResponse(
    public val resourceType: String,
    public val targetResourceGroupName: String? = null,
    public val targetResourceName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.SqlServerResourceSettingsResponse):
            SqlServerResourceSettingsResponse = SqlServerResourceSettingsResponse(
            resourceType = javaType.resourceType(),
            targetResourceGroupName = javaType.targetResourceGroupName().map({ args0 -> args0 }).orElse(null),
            targetResourceName = javaType.targetResourceName(),
        )
    }
}
