@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mixedreality.kotlin

import com.pulumi.azurenative.mixedreality.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.mixedreality.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.mixedreality.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.mixedreality.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.mixedreality.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.mixedreality.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SpatialAnchorsAccount].
 */
@PulumiTagMarker
public class SpatialAnchorsAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SpatialAnchorsAccountArgs = SpatialAnchorsAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SpatialAnchorsAccountArgsBuilder.() -> Unit) {
        val builder = SpatialAnchorsAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SpatialAnchorsAccount {
        val builtJavaResource =
            com.pulumi.azurenative.mixedreality.SpatialAnchorsAccount(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SpatialAnchorsAccount(builtJavaResource)
    }
}

/**
 * SpatialAnchorsAccount Response.
 * Azure REST API version: 2021-01-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2019-02-28-preview, 2021-03-01-preview.
 * ## Example Usage
 * ### Create spatial anchor account
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var spatialAnchorsAccount = new AzureNative.MixedReality.SpatialAnchorsAccount("spatialAnchorsAccount", new()
 *     {
 *         AccountName = "MyAccount",
 *         Location = "eastus2euap",
 *         ResourceGroupName = "MyResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mixedreality/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mixedreality.NewSpatialAnchorsAccount(ctx, "spatialAnchorsAccount", &mixedreality.SpatialAnchorsAccountArgs{
 * 			AccountName:       pulumi.String("MyAccount"),
 * 			Location:          pulumi.String("eastus2euap"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mixedreality.SpatialAnchorsAccount;
 * import com.pulumi.azurenative.mixedreality.SpatialAnchorsAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var spatialAnchorsAccount = new SpatialAnchorsAccount("spatialAnchorsAccount", SpatialAnchorsAccountArgs.builder()
 *             .accountName("MyAccount")
 *             .location("eastus2euap")
 *             .resourceGroupName("MyResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mixedreality:SpatialAnchorsAccount MyAccount /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MixedReality/spatialAnchorsAccounts/{accountName}
 * ```
 */
public class SpatialAnchorsAccount internal constructor(
    override val javaResource: com.pulumi.azurenative.mixedreality.SpatialAnchorsAccount,
) : KotlinCustomResource(javaResource, SpatialAnchorsAccountMapper) {
    /**
     * Correspond domain name of certain Spatial Anchors Account
     */
    public val accountDomain: Output<String>
        get() = javaResource.accountDomain().applyValue({ args0 -> args0 })

    /**
     * unique id of certain account.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })

    /**
     * The identity associated with this account
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The kind of account, if supported
     */
    public val kind: Output<SkuResponse>?
        get() = javaResource.kind().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The plan associated with this account
     */
    public val plan: Output<IdentityResponse>?
        get() = javaResource.plan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The sku associated with this account
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the storage account associated with this accountId
     */
    public val storageAccountName: Output<String>?
        get() = javaResource.storageAccountName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * System metadata for this account
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SpatialAnchorsAccountMapper : ResourceMapper<SpatialAnchorsAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.mixedreality.SpatialAnchorsAccount::class == javaResource::class

    override fun map(javaResource: Resource): SpatialAnchorsAccount =
        SpatialAnchorsAccount(
            javaResource as
                com.pulumi.azurenative.mixedreality.SpatialAnchorsAccount,
        )
}

/**
 * @see [SpatialAnchorsAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SpatialAnchorsAccount].
 */
public suspend fun spatialAnchorsAccount(
    name: String,
    block: suspend SpatialAnchorsAccountResourceBuilder.() -> Unit,
): SpatialAnchorsAccount {
    val builder = SpatialAnchorsAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SpatialAnchorsAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun spatialAnchorsAccount(name: String): SpatialAnchorsAccount {
    val builder = SpatialAnchorsAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
