@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [DataNetwork].
 */
@PulumiTagMarker
public class DataNetworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataNetworkArgs = DataNetworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataNetworkArgsBuilder.() -> Unit) {
        val builder = DataNetworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DataNetwork {
        val builtJavaResource =
            com.pulumi.azurenative.mobilenetwork.DataNetwork(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DataNetwork(builtJavaResource)
    }
}

/**
 * Data network resource. Must be created in the same location as its parent mobile network.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01.
 * ## Example Usage
 * ### Create data network
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataNetwork = new AzureNative.MobileNetwork.DataNetwork("dataNetwork", new()
 *     {
 *         DataNetworkName = "testDataNetwork",
 *         Description = "myFavouriteDataNetwork",
 *         Location = "eastus",
 *         MobileNetworkName = "testMobileNetwork",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewDataNetwork(ctx, "dataNetwork", &mobilenetwork.DataNetworkArgs{
 * 			DataNetworkName:   pulumi.String("testDataNetwork"),
 * 			Description:       pulumi.String("myFavouriteDataNetwork"),
 * 			Location:          pulumi.String("eastus"),
 * 			MobileNetworkName: pulumi.String("testMobileNetwork"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.DataNetwork;
 * import com.pulumi.azurenative.mobilenetwork.DataNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataNetwork = new DataNetwork("dataNetwork", DataNetworkArgs.builder()
 *             .dataNetworkName("testDataNetwork")
 *             .description("myFavouriteDataNetwork")
 *             .location("eastus")
 *             .mobileNetworkName("testMobileNetwork")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:DataNetwork testDataNetwork /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/mobileNetworks/{mobileNetworkName}/dataNetworks/{dataNetworkName}
 * ```
 */
public class DataNetwork internal constructor(
    override val javaResource: com.pulumi.azurenative.mobilenetwork.DataNetwork,
) : KotlinCustomResource(javaResource, DataNetworkMapper) {
    /**
     * An optional description for this data network.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the data network resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DataNetworkMapper : ResourceMapper<DataNetwork> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.mobilenetwork.DataNetwork::class == javaResource::class

    override fun map(javaResource: Resource): DataNetwork = DataNetwork(
        javaResource as
            com.pulumi.azurenative.mobilenetwork.DataNetwork,
    )
}

/**
 * @see [DataNetwork].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataNetwork].
 */
public suspend fun dataNetwork(name: String, block: suspend DataNetworkResourceBuilder.() -> Unit):
    DataNetwork {
    val builder = DataNetworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataNetwork].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataNetwork(name: String): DataNetwork {
    val builder = DataNetworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
