@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.DataNetworkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Data network resource. Must be created in the same location as its parent mobile network.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01.
 * ## Example Usage
 * ### Create data network
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataNetwork = new AzureNative.MobileNetwork.DataNetwork("dataNetwork", new()
 *     {
 *         DataNetworkName = "testDataNetwork",
 *         Description = "myFavouriteDataNetwork",
 *         Location = "eastus",
 *         MobileNetworkName = "testMobileNetwork",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewDataNetwork(ctx, "dataNetwork", &mobilenetwork.DataNetworkArgs{
 * 			DataNetworkName:   pulumi.String("testDataNetwork"),
 * 			Description:       pulumi.String("myFavouriteDataNetwork"),
 * 			Location:          pulumi.String("eastus"),
 * 			MobileNetworkName: pulumi.String("testMobileNetwork"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.DataNetwork;
 * import com.pulumi.azurenative.mobilenetwork.DataNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataNetwork = new DataNetwork("dataNetwork", DataNetworkArgs.builder()
 *             .dataNetworkName("testDataNetwork")
 *             .description("myFavouriteDataNetwork")
 *             .location("eastus")
 *             .mobileNetworkName("testMobileNetwork")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:DataNetwork testDataNetwork /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/mobileNetworks/{mobileNetworkName}/dataNetworks/{dataNetworkName}
 * ```
 * @property dataNetworkName The name of the data network.
 * @property description An optional description for this data network.
 * @property location The geo-location where the resource lives
 * @property mobileNetworkName The name of the mobile network.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class DataNetworkArgs(
    public val dataNetworkName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val location: Output<String>? = null,
    public val mobileNetworkName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.DataNetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.DataNetworkArgs =
        com.pulumi.azurenative.mobilenetwork.DataNetworkArgs.builder()
            .dataNetworkName(dataNetworkName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mobileNetworkName(mobileNetworkName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DataNetworkArgs].
 */
@PulumiTagMarker
public class DataNetworkArgsBuilder internal constructor() {
    private var dataNetworkName: Output<String>? = null

    private var description: Output<String>? = null

    private var location: Output<String>? = null

    private var mobileNetworkName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the data network.
     */
    @JvmName("gyftqtjckkummmvj")
    public suspend fun dataNetworkName(`value`: Output<String>) {
        this.dataNetworkName = value
    }

    /**
     * @param value An optional description for this data network.
     */
    @JvmName("raxfvarlugjqxfql")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gjpmiiueaihjyteh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the mobile network.
     */
    @JvmName("mygyemvdmufqdohl")
    public suspend fun mobileNetworkName(`value`: Output<String>) {
        this.mobileNetworkName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gwpckdhbdqwfaeqt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tlhvuxmuvllkrfdo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the data network.
     */
    @JvmName("rlbabgaxciexqhhx")
    public suspend fun dataNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataNetworkName = mapped
    }

    /**
     * @param value An optional description for this data network.
     */
    @JvmName("adsoiphilxpnsbfk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ehfynhpomvmtsvti")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the mobile network.
     */
    @JvmName("dbpkmpapmvdiowjv")
    public suspend fun mobileNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mobileNetworkName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jnthctkumnryhwvc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tmqiqylhrhlpvhrl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("rioojlgihjgxrfbw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DataNetworkArgs = DataNetworkArgs(
        dataNetworkName = dataNetworkName,
        description = description,
        location = location,
        mobileNetworkName = mobileNetworkName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
