@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.MobileNetworkArgs.builder
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.PlmnIdArgs
import com.pulumi.azurenative.mobilenetwork.kotlin.inputs.PlmnIdArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Mobile network resource.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-04-01-preview, 2022-11-01, 2023-09-01.
 * ## Example Usage
 * ### Create mobile network
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mobileNetwork = new AzureNative.MobileNetwork.MobileNetwork("mobileNetwork", new()
 *     {
 *         Location = "eastus",
 *         MobileNetworkName = "testMobileNetwork",
 *         PublicLandMobileNetworkIdentifier = new AzureNative.MobileNetwork.Inputs.PlmnIdArgs
 *         {
 *             Mcc = "001",
 *             Mnc = "01",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewMobileNetwork(ctx, "mobileNetwork", &mobilenetwork.MobileNetworkArgs{
 * 			Location:          pulumi.String("eastus"),
 * 			MobileNetworkName: pulumi.String("testMobileNetwork"),
 * 			PublicLandMobileNetworkIdentifier: &mobilenetwork.PlmnIdArgs{
 * 				Mcc: pulumi.String("001"),
 * 				Mnc: pulumi.String("01"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.MobileNetwork;
 * import com.pulumi.azurenative.mobilenetwork.MobileNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mobileNetwork = new MobileNetwork("mobileNetwork", MobileNetworkArgs.builder()
 *             .location("eastus")
 *             .mobileNetworkName("testMobileNetwork")
 *             .publicLandMobileNetworkIdentifier(Map.ofEntries(
 *                 Map.entry("mcc", "001"),
 *                 Map.entry("mnc", "01")
 *             ))
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:MobileNetwork testMobileNetwork /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/mobileNetworks/{mobileNetworkName}
 * ```
 * @property location The geo-location where the resource lives
 * @property mobileNetworkName The name of the mobile network.
 * @property publicLandMobileNetworkIdentifier The unique public land mobile network identifier for the network. This is made up of the mobile country code and mobile network code, as defined in https://www.itu.int/rec/T-REC-E.212. The values 001-01 and 001-001 can be used for testing and the values 999-99 and 999-999 can be used on internal private networks.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class MobileNetworkArgs(
    public val location: Output<String>? = null,
    public val mobileNetworkName: Output<String>? = null,
    public val publicLandMobileNetworkIdentifier: Output<PlmnIdArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.MobileNetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.MobileNetworkArgs =
        com.pulumi.azurenative.mobilenetwork.MobileNetworkArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .mobileNetworkName(mobileNetworkName?.applyValue({ args0 -> args0 }))
            .publicLandMobileNetworkIdentifier(
                publicLandMobileNetworkIdentifier?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MobileNetworkArgs].
 */
@PulumiTagMarker
public class MobileNetworkArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var mobileNetworkName: Output<String>? = null

    private var publicLandMobileNetworkIdentifier: Output<PlmnIdArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rdgwsmgxcrfntrhb")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the mobile network.
     */
    @JvmName("otmuhijuafsvijas")
    public suspend fun mobileNetworkName(`value`: Output<String>) {
        this.mobileNetworkName = value
    }

    /**
     * @param value The unique public land mobile network identifier for the network. This is made up of the mobile country code and mobile network code, as defined in https://www.itu.int/rec/T-REC-E.212. The values 001-01 and 001-001 can be used for testing and the values 999-99 and 999-999 can be used on internal private networks.
     */
    @JvmName("dmyjacmklvkqpnqx")
    public suspend fun publicLandMobileNetworkIdentifier(`value`: Output<PlmnIdArgs>) {
        this.publicLandMobileNetworkIdentifier = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lekkfvbmrpyhohia")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mcbovkpqtjdhalex")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("cvotavqeywmitybr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the mobile network.
     */
    @JvmName("suklpiyqcbxejper")
    public suspend fun mobileNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mobileNetworkName = mapped
    }

    /**
     * @param value The unique public land mobile network identifier for the network. This is made up of the mobile country code and mobile network code, as defined in https://www.itu.int/rec/T-REC-E.212. The values 001-01 and 001-001 can be used for testing and the values 999-99 and 999-999 can be used on internal private networks.
     */
    @JvmName("ofmfbbatlkdnleug")
    public suspend fun publicLandMobileNetworkIdentifier(`value`: PlmnIdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicLandMobileNetworkIdentifier = mapped
    }

    /**
     * @param argument The unique public land mobile network identifier for the network. This is made up of the mobile country code and mobile network code, as defined in https://www.itu.int/rec/T-REC-E.212. The values 001-01 and 001-001 can be used for testing and the values 999-99 and 999-999 can be used on internal private networks.
     */
    @JvmName("lyyhmbrmpwotwysr")
    public suspend
    fun publicLandMobileNetworkIdentifier(argument: suspend PlmnIdArgsBuilder.() -> Unit) {
        val toBeMapped = PlmnIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicLandMobileNetworkIdentifier = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("scrphwlwwdfnfakg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gxxmhwmickvaeyxb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("oghhxxkrncrmpbir")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MobileNetworkArgs = MobileNetworkArgs(
        location = location,
        mobileNetworkName = mobileNetworkName,
        publicLandMobileNetworkIdentifier = publicLandMobileNetworkIdentifier,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
