@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin

import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SimPolicyResourceIdResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SimStaticIpPropertiesResponse
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SimPolicyResourceIdResponse.Companion.toKotlin as simPolicyResourceIdResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SimStaticIpPropertiesResponse.Companion.toKotlin as simStaticIpPropertiesResponseToKotlin
import com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Sim].
 */
@PulumiTagMarker
public class SimResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SimArgs = SimArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SimArgsBuilder.() -> Unit) {
        val builder = SimArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Sim {
        val builtJavaResource = com.pulumi.azurenative.mobilenetwork.Sim(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Sim(builtJavaResource)
    }
}

/**
 * SIM resource.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-03-01-preview, 2022-04-01-preview, 2022-11-01, 2023-09-01.
 * ## Example Usage
 * ### Create SIM
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sim = new AzureNative.MobileNetwork.Sim("sim", new()
 *     {
 *         AuthenticationKey = "00000000000000000000000000000000",
 *         DeviceType = "Video camera",
 *         IntegratedCircuitCardIdentifier = "8900000000000000000",
 *         InternationalMobileSubscriberIdentity = "00000",
 *         OperatorKeyCode = "00000000000000000000000000000000",
 *         ResourceGroupName = "rg1",
 *         SimGroupName = "testSimGroup",
 *         SimName = "testSim",
 *         SimPolicy = new AzureNative.MobileNetwork.Inputs.SimPolicyResourceIdArgs
 *         {
 *             Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/simPolicies/MySimPolicy",
 *         },
 *         StaticIpConfiguration = new[]
 *         {
 *             new AzureNative.MobileNetwork.Inputs.SimStaticIpPropertiesArgs
 *             {
 *                 AttachedDataNetwork = new AzureNative.MobileNetwork.Inputs.AttachedDataNetworkResourceIdArgs
 *                 {
 *                     Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP/attachedDataNetworks/TestAttachedDataNetwork",
 *                 },
 *                 Slice = new AzureNative.MobileNetwork.Inputs.SliceResourceIdArgs
 *                 {
 *                     Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice",
 *                 },
 *                 StaticIp = new AzureNative.MobileNetwork.Inputs.SimStaticIpPropertiesStaticIpArgs
 *                 {
 *                     Ipv4Address = "2.4.0.1",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/mobilenetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mobilenetwork.NewSim(ctx, "sim", &mobilenetwork.SimArgs{
 * 			AuthenticationKey:                     pulumi.String("00000000000000000000000000000000"),
 * 			DeviceType:                            pulumi.String("Video camera"),
 * 			IntegratedCircuitCardIdentifier:       pulumi.String("8900000000000000000"),
 * 			InternationalMobileSubscriberIdentity: pulumi.String("00000"),
 * 			OperatorKeyCode:                       pulumi.String("00000000000000000000000000000000"),
 * 			ResourceGroupName:                     pulumi.String("rg1"),
 * 			SimGroupName:                          pulumi.String("testSimGroup"),
 * 			SimName:                               pulumi.String("testSim"),
 * 			SimPolicy: &mobilenetwork.SimPolicyResourceIdArgs{
 * 				Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/simPolicies/MySimPolicy"),
 * 			},
 * 			StaticIpConfiguration: []mobilenetwork.SimStaticIpPropertiesArgs{
 * 				{
 * 					AttachedDataNetwork: {
 * 						Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP/attachedDataNetworks/TestAttachedDataNetwork"),
 * 					},
 * 					Slice: {
 * 						Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice"),
 * 					},
 * 					StaticIp: {
 * 						Ipv4Address: pulumi.String("2.4.0.1"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.mobilenetwork.Sim;
 * import com.pulumi.azurenative.mobilenetwork.SimArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sim = new Sim("sim", SimArgs.builder()
 *             .authenticationKey("00000000000000000000000000000000")
 *             .deviceType("Video camera")
 *             .integratedCircuitCardIdentifier("8900000000000000000")
 *             .internationalMobileSubscriberIdentity("00000")
 *             .operatorKeyCode("00000000000000000000000000000000")
 *             .resourceGroupName("rg1")
 *             .simGroupName("testSimGroup")
 *             .simName("testSim")
 *             .simPolicy(Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/simPolicies/MySimPolicy"))
 *             .staticIpConfiguration(Map.ofEntries(
 *                 Map.entry("attachedDataNetwork", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/TestPacketCoreCP/packetCoreDataPlanes/TestPacketCoreDP/attachedDataNetworks/TestAttachedDataNetwork")),
 *                 Map.entry("slice", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.MobileNetwork/mobileNetworks/testMobileNetwork/slices/testSlice")),
 *                 Map.entry("staticIp", Map.of("ipv4Address", "2.4.0.1"))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:mobilenetwork:Sim testSim /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileNetwork/simGroups/{simGroupName}/sims/{simName}
 * ```
 */
public class Sim internal constructor(
    override val javaResource: com.pulumi.azurenative.mobilenetwork.Sim,
) : KotlinCustomResource(javaResource, SimMapper) {
    /**
     * An optional free-form text field that can be used to record the device type this SIM is associated with, for example 'Video camera'. The Azure portal allows SIMs to be grouped and filtered based on this value.
     */
    public val deviceType: Output<String>?
        get() = javaResource.deviceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The integrated circuit card ID (ICCID) for the SIM.
     */
    public val integratedCircuitCardIdentifier: Output<String>?
        get() = javaResource.integratedCircuitCardIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The international mobile subscriber identity (IMSI) for the SIM.
     */
    public val internationalMobileSubscriberIdentity: Output<String>
        get() = javaResource.internationalMobileSubscriberIdentity().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the SIM resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The SIM policy used by this SIM. The SIM policy must be in the same location as the SIM.
     */
    public val simPolicy: Output<SimPolicyResourceIdResponse>?
        get() = javaResource.simPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    simPolicyResourceIdResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The state of the SIM resource.
     */
    public val simState: Output<String>
        get() = javaResource.simState().applyValue({ args0 -> args0 })

    /**
     * A dictionary of sites to the provisioning state of this SIM on that site.
     */
    public val siteProvisioningState: Output<Map<String, String>>
        get() = javaResource.siteProvisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A list of static IP addresses assigned to this SIM. Each address is assigned at a defined network scope, made up of {attached data network, slice}.
     */
    public val staticIpConfiguration: Output<List<SimStaticIpPropertiesResponse>>?
        get() = javaResource.staticIpConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        simStaticIpPropertiesResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The public key fingerprint of the SIM vendor who provided this SIM, if any.
     */
    public val vendorKeyFingerprint: Output<String>
        get() = javaResource.vendorKeyFingerprint().applyValue({ args0 -> args0 })

    /**
     * The name of the SIM vendor who provided this SIM, if any.
     */
    public val vendorName: Output<String>
        get() = javaResource.vendorName().applyValue({ args0 -> args0 })
}

public object SimMapper : ResourceMapper<Sim> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.mobilenetwork.Sim::class == javaResource::class

    override fun map(javaResource: Resource): Sim = Sim(
        javaResource as
            com.pulumi.azurenative.mobilenetwork.Sim,
    )
}

/**
 * @see [Sim].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Sim].
 */
public suspend fun sim(name: String, block: suspend SimResourceBuilder.() -> Unit): Sim {
    val builder = SimResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Sim].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sim(name: String): Sim {
    val builder = SimResourceBuilder()
    builder.name(name)
    return builder.build()
}
