@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The desired installation state
 */
public enum class DesiredInstallationState(
    public val javaValue: com.pulumi.azurenative.mobilenetwork.enums.DesiredInstallationState,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.enums.DesiredInstallationState> {
    /**
     * Don't install the packet core.
     */
    Uninstalled(com.pulumi.azurenative.mobilenetwork.enums.DesiredInstallationState.Uninstalled),

    /**
     * Install the packet core.
     */
    Installed(com.pulumi.azurenative.mobilenetwork.enums.DesiredInstallationState.Installed),
    ;

    override fun toJava(): com.pulumi.azurenative.mobilenetwork.enums.DesiredInstallationState =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.enums.DesiredInstallationState):
            DesiredInstallationState =
            DesiredInstallationState.values().first { it.javaValue == javaType }
    }
}
