@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.CustomLocationResourceIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Reference to an Azure Arc custom location resource.
 * @property id Azure Arc custom location resource ID.
 */
public data class CustomLocationResourceIdArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.CustomLocationResourceIdArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.CustomLocationResourceIdArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.CustomLocationResourceIdArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomLocationResourceIdArgs].
 */
@PulumiTagMarker
public class CustomLocationResourceIdArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Azure Arc custom location resource ID.
     */
    @JvmName("jpkxphwedojvnwva")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Azure Arc custom location resource ID.
     */
    @JvmName("vohwajtmhadjpjxr")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): CustomLocationResourceIdArgs = CustomLocationResourceIdArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
