@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.LocalDiagnosticsAccessConfigurationArgs.builder
import com.pulumi.azurenative.mobilenetwork.kotlin.enums.AuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The kubernetes ingress configuration to control access to packet core diagnostics over local APIs.
 * @property authenticationType How to authenticate users who access local diagnostics APIs.
 * @property httpsServerCertificate The HTTPS server TLS certificate used to secure local access to diagnostics.
 */
public data class LocalDiagnosticsAccessConfigurationArgs(
    public val authenticationType: Output<Either<String, AuthenticationType>>,
    public val httpsServerCertificate: Output<HttpsServerCertificateArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.LocalDiagnosticsAccessConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.mobilenetwork.inputs.LocalDiagnosticsAccessConfigurationArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.LocalDiagnosticsAccessConfigurationArgs.builder()
            .authenticationType(
                authenticationType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .httpsServerCertificate(
                httpsServerCertificate?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [LocalDiagnosticsAccessConfigurationArgs].
 */
@PulumiTagMarker
public class LocalDiagnosticsAccessConfigurationArgsBuilder internal constructor() {
    private var authenticationType: Output<Either<String, AuthenticationType>>? = null

    private var httpsServerCertificate: Output<HttpsServerCertificateArgs>? = null

    /**
     * @param value How to authenticate users who access local diagnostics APIs.
     */
    @JvmName("smvpxbsilkwtlywx")
    public suspend fun authenticationType(`value`: Output<Either<String, AuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value The HTTPS server TLS certificate used to secure local access to diagnostics.
     */
    @JvmName("srewnhsavxffcsmd")
    public suspend fun httpsServerCertificate(`value`: Output<HttpsServerCertificateArgs>) {
        this.httpsServerCertificate = value
    }

    /**
     * @param value How to authenticate users who access local diagnostics APIs.
     */
    @JvmName("wfbjnkylnfeeivqs")
    public suspend fun authenticationType(`value`: Either<String, AuthenticationType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value How to authenticate users who access local diagnostics APIs.
     */
    @JvmName("sgodyplcdjsrywom")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value How to authenticate users who access local diagnostics APIs.
     */
    @JvmName("qfwwhfqhkcliudck")
    public fun authenticationType(`value`: AuthenticationType) {
        val toBeMapped = Either.ofRight<String, AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The HTTPS server TLS certificate used to secure local access to diagnostics.
     */
    @JvmName("ndsgjksstopxxtio")
    public suspend fun httpsServerCertificate(`value`: HttpsServerCertificateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsServerCertificate = mapped
    }

    /**
     * @param argument The HTTPS server TLS certificate used to secure local access to diagnostics.
     */
    @JvmName("ijnctarpjnwblydv")
    public suspend
    fun httpsServerCertificate(argument: suspend HttpsServerCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = HttpsServerCertificateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpsServerCertificate = mapped
    }

    internal fun build(): LocalDiagnosticsAccessConfigurationArgs =
        LocalDiagnosticsAccessConfigurationArgs(
            authenticationType = authenticationType ?: throw PulumiNullFieldException("authenticationType"),
            httpsServerCertificate = httpsServerCertificate,
        )
}
