@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.NaptConfigurationArgs.builder
import com.pulumi.azurenative.mobilenetwork.kotlin.enums.NaptEnabled
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The network address and port translation settings to use for the attached data network.
 * @property enabled Whether NAPT is enabled for connections to this attached data network.
 * @property pinholeLimits Maximum number of UDP and TCP pinholes that can be open simultaneously on the core interface. For 5G networks, this is the N6 interface. For 4G networks, this is the SGi interface.
 * @property pinholeTimeouts Expiry times of inactive NAPT pinholes, in seconds. All timers must be at least 1 second.
 * @property portRange Range of port numbers to use as translated ports on each translated address.
 * If not specified and NAPT is enabled, this range defaults to 1,024 - 49,999.
 * (Ports under 1,024 should not be used because these are special purpose ports reserved by IANA. Ports 50,000 and above are reserved for non-NAPT use.)
 * @property portReuseHoldTime The minimum time (in seconds) that will pass before a port that was used by a closed pinhole can be recycled for use by another pinhole. All hold times must be at least 1 second.
 */
public data class NaptConfigurationArgs(
    public val enabled: Output<Either<String, NaptEnabled>>? = null,
    public val pinholeLimits: Output<Int>? = null,
    public val pinholeTimeouts: Output<PinholeTimeoutsArgs>? = null,
    public val portRange: Output<PortRangeArgs>? = null,
    public val portReuseHoldTime: Output<PortReuseHoldTimesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.NaptConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.NaptConfigurationArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.NaptConfigurationArgs.builder()
            .enabled(
                enabled?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .pinholeLimits(pinholeLimits?.applyValue({ args0 -> args0 }))
            .pinholeTimeouts(pinholeTimeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .portRange(portRange?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .portReuseHoldTime(
                portReuseHoldTime?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [NaptConfigurationArgs].
 */
@PulumiTagMarker
public class NaptConfigurationArgsBuilder internal constructor() {
    private var enabled: Output<Either<String, NaptEnabled>>? = null

    private var pinholeLimits: Output<Int>? = null

    private var pinholeTimeouts: Output<PinholeTimeoutsArgs>? = null

    private var portRange: Output<PortRangeArgs>? = null

    private var portReuseHoldTime: Output<PortReuseHoldTimesArgs>? = null

    /**
     * @param value Whether NAPT is enabled for connections to this attached data network.
     */
    @JvmName("gupftycjobrffoum")
    public suspend fun enabled(`value`: Output<Either<String, NaptEnabled>>) {
        this.enabled = value
    }

    /**
     * @param value Maximum number of UDP and TCP pinholes that can be open simultaneously on the core interface. For 5G networks, this is the N6 interface. For 4G networks, this is the SGi interface.
     */
    @JvmName("jtmbdoqnpriygecq")
    public suspend fun pinholeLimits(`value`: Output<Int>) {
        this.pinholeLimits = value
    }

    /**
     * @param value Expiry times of inactive NAPT pinholes, in seconds. All timers must be at least 1 second.
     */
    @JvmName("gaxnmwxvegcimwno")
    public suspend fun pinholeTimeouts(`value`: Output<PinholeTimeoutsArgs>) {
        this.pinholeTimeouts = value
    }

    /**
     * @param value Range of port numbers to use as translated ports on each translated address.
     * If not specified and NAPT is enabled, this range defaults to 1,024 - 49,999.
     * (Ports under 1,024 should not be used because these are special purpose ports reserved by IANA. Ports 50,000 and above are reserved for non-NAPT use.)
     */
    @JvmName("jkdykhqwjvprbvxj")
    public suspend fun portRange(`value`: Output<PortRangeArgs>) {
        this.portRange = value
    }

    /**
     * @param value The minimum time (in seconds) that will pass before a port that was used by a closed pinhole can be recycled for use by another pinhole. All hold times must be at least 1 second.
     */
    @JvmName("rvqtmdepkyfjfgsc")
    public suspend fun portReuseHoldTime(`value`: Output<PortReuseHoldTimesArgs>) {
        this.portReuseHoldTime = value
    }

    /**
     * @param value Whether NAPT is enabled for connections to this attached data network.
     */
    @JvmName("kdanbksakibvlryh")
    public suspend fun enabled(`value`: Either<String, NaptEnabled>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Whether NAPT is enabled for connections to this attached data network.
     */
    @JvmName("pndgvggmdtruxhgt")
    public fun enabled(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NaptEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Whether NAPT is enabled for connections to this attached data network.
     */
    @JvmName("qxygfeicgxhifoib")
    public fun enabled(`value`: NaptEnabled) {
        val toBeMapped = Either.ofRight<String, NaptEnabled>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Maximum number of UDP and TCP pinholes that can be open simultaneously on the core interface. For 5G networks, this is the N6 interface. For 4G networks, this is the SGi interface.
     */
    @JvmName("bwgsuxbktomslfoy")
    public suspend fun pinholeLimits(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pinholeLimits = mapped
    }

    /**
     * @param value Expiry times of inactive NAPT pinholes, in seconds. All timers must be at least 1 second.
     */
    @JvmName("gjtcxyekrjwhbbly")
    public suspend fun pinholeTimeouts(`value`: PinholeTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pinholeTimeouts = mapped
    }

    /**
     * @param argument Expiry times of inactive NAPT pinholes, in seconds. All timers must be at least 1 second.
     */
    @JvmName("fefpfjjoolllplhd")
    public suspend fun pinholeTimeouts(argument: suspend PinholeTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = PinholeTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.pinholeTimeouts = mapped
    }

    /**
     * @param value Range of port numbers to use as translated ports on each translated address.
     * If not specified and NAPT is enabled, this range defaults to 1,024 - 49,999.
     * (Ports under 1,024 should not be used because these are special purpose ports reserved by IANA. Ports 50,000 and above are reserved for non-NAPT use.)
     */
    @JvmName("gxbbuyujketaouty")
    public suspend fun portRange(`value`: PortRangeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portRange = mapped
    }

    /**
     * @param argument Range of port numbers to use as translated ports on each translated address.
     * If not specified and NAPT is enabled, this range defaults to 1,024 - 49,999.
     * (Ports under 1,024 should not be used because these are special purpose ports reserved by IANA. Ports 50,000 and above are reserved for non-NAPT use.)
     */
    @JvmName("wkvsvlviewncvjnr")
    public suspend fun portRange(argument: suspend PortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = PortRangeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.portRange = mapped
    }

    /**
     * @param value The minimum time (in seconds) that will pass before a port that was used by a closed pinhole can be recycled for use by another pinhole. All hold times must be at least 1 second.
     */
    @JvmName("slapevqruylbktsv")
    public suspend fun portReuseHoldTime(`value`: PortReuseHoldTimesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portReuseHoldTime = mapped
    }

    /**
     * @param argument The minimum time (in seconds) that will pass before a port that was used by a closed pinhole can be recycled for use by another pinhole. All hold times must be at least 1 second.
     */
    @JvmName("bcjbcdobfvkafnwv")
    public suspend fun portReuseHoldTime(argument: suspend PortReuseHoldTimesArgsBuilder.() -> Unit) {
        val toBeMapped = PortReuseHoldTimesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.portReuseHoldTime = mapped
    }

    internal fun build(): NaptConfigurationArgs = NaptConfigurationArgs(
        enabled = enabled,
        pinholeLimits = pinholeLimits,
        pinholeTimeouts = pinholeTimeouts,
        portRange = portRange,
        portReuseHoldTime = portReuseHoldTime,
    )
}
