@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.PccRuleConfigurationArgs.builder
import com.pulumi.azurenative.mobilenetwork.kotlin.enums.TrafficControlPermission
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Data flow policy rule configuration
 * @property ruleName The name of the rule. This must be unique within the parent service. You must not use any of the following reserved strings - `default`, `requested` or `service`.
 * @property rulePrecedence A precedence value that is used to decide between data flow policy rules when identifying the QoS values to use for a particular SIM. A lower value means a higher priority. This value should be unique among all data flow policy rules configured in the mobile network.
 * @property ruleQosPolicy The QoS policy to use for packets matching this rule. If this field is null then the parent service will define the QoS settings.
 * @property serviceDataFlowTemplates The set of data flow templates to use for this data flow policy rule.
 * @property trafficControl Determines whether flows that match this data flow policy rule are permitted.
 */
public data class PccRuleConfigurationArgs(
    public val ruleName: Output<String>,
    public val rulePrecedence: Output<Int>,
    public val ruleQosPolicy: Output<PccRuleQosPolicyArgs>? = null,
    public val serviceDataFlowTemplates: Output<List<ServiceDataFlowTemplateArgs>>,
    public val trafficControl: Output<Either<String, TrafficControlPermission>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.PccRuleConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.PccRuleConfigurationArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.PccRuleConfigurationArgs.builder()
            .ruleName(ruleName.applyValue({ args0 -> args0 }))
            .rulePrecedence(rulePrecedence.applyValue({ args0 -> args0 }))
            .ruleQosPolicy(ruleQosPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceDataFlowTemplates(
                serviceDataFlowTemplates.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .trafficControl(
                trafficControl?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PccRuleConfigurationArgs].
 */
@PulumiTagMarker
public class PccRuleConfigurationArgsBuilder internal constructor() {
    private var ruleName: Output<String>? = null

    private var rulePrecedence: Output<Int>? = null

    private var ruleQosPolicy: Output<PccRuleQosPolicyArgs>? = null

    private var serviceDataFlowTemplates: Output<List<ServiceDataFlowTemplateArgs>>? = null

    private var trafficControl: Output<Either<String, TrafficControlPermission>>? = null

    /**
     * @param value The name of the rule. This must be unique within the parent service. You must not use any of the following reserved strings - `default`, `requested` or `service`.
     */
    @JvmName("guqkpswpdscwjrqt")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value A precedence value that is used to decide between data flow policy rules when identifying the QoS values to use for a particular SIM. A lower value means a higher priority. This value should be unique among all data flow policy rules configured in the mobile network.
     */
    @JvmName("saaubmowfsibjbsh")
    public suspend fun rulePrecedence(`value`: Output<Int>) {
        this.rulePrecedence = value
    }

    /**
     * @param value The QoS policy to use for packets matching this rule. If this field is null then the parent service will define the QoS settings.
     */
    @JvmName("qkafuyshexvnatdo")
    public suspend fun ruleQosPolicy(`value`: Output<PccRuleQosPolicyArgs>) {
        this.ruleQosPolicy = value
    }

    /**
     * @param value The set of data flow templates to use for this data flow policy rule.
     */
    @JvmName("wnajtgnoccgsaerp")
    public suspend fun serviceDataFlowTemplates(`value`: Output<List<ServiceDataFlowTemplateArgs>>) {
        this.serviceDataFlowTemplates = value
    }

    @JvmName("gmfevxfsoffabpgy")
    public suspend fun serviceDataFlowTemplates(vararg values: Output<ServiceDataFlowTemplateArgs>) {
        this.serviceDataFlowTemplates = Output.all(values.asList())
    }

    /**
     * @param values The set of data flow templates to use for this data flow policy rule.
     */
    @JvmName("sclssxfjipaksigq")
    public suspend fun serviceDataFlowTemplates(values: List<Output<ServiceDataFlowTemplateArgs>>) {
        this.serviceDataFlowTemplates = Output.all(values)
    }

    /**
     * @param value Determines whether flows that match this data flow policy rule are permitted.
     */
    @JvmName("yjilagfimgbgekqt")
    public suspend fun trafficControl(`value`: Output<Either<String, TrafficControlPermission>>) {
        this.trafficControl = value
    }

    /**
     * @param value The name of the rule. This must be unique within the parent service. You must not use any of the following reserved strings - `default`, `requested` or `service`.
     */
    @JvmName("rhbgavaujddbiecg")
    public suspend fun ruleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value A precedence value that is used to decide between data flow policy rules when identifying the QoS values to use for a particular SIM. A lower value means a higher priority. This value should be unique among all data flow policy rules configured in the mobile network.
     */
    @JvmName("kqkdjlwysrabhcsg")
    public suspend fun rulePrecedence(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rulePrecedence = mapped
    }

    /**
     * @param value The QoS policy to use for packets matching this rule. If this field is null then the parent service will define the QoS settings.
     */
    @JvmName("pkgjhhcrtwhxwajd")
    public suspend fun ruleQosPolicy(`value`: PccRuleQosPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleQosPolicy = mapped
    }

    /**
     * @param argument The QoS policy to use for packets matching this rule. If this field is null then the parent service will define the QoS settings.
     */
    @JvmName("okuskaxatcbwxers")
    public suspend fun ruleQosPolicy(argument: suspend PccRuleQosPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = PccRuleQosPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ruleQosPolicy = mapped
    }

    /**
     * @param value The set of data flow templates to use for this data flow policy rule.
     */
    @JvmName("jwapltixxhqvwftp")
    public suspend fun serviceDataFlowTemplates(`value`: List<ServiceDataFlowTemplateArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceDataFlowTemplates = mapped
    }

    /**
     * @param argument The set of data flow templates to use for this data flow policy rule.
     */
    @JvmName("banqpuwppummhsnd")
    public suspend
    fun serviceDataFlowTemplates(argument: List<suspend ServiceDataFlowTemplateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceDataFlowTemplateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceDataFlowTemplates = mapped
    }

    /**
     * @param argument The set of data flow templates to use for this data flow policy rule.
     */
    @JvmName("lnovbwnasovchjpx")
    public suspend fun serviceDataFlowTemplates(
        vararg
        argument: suspend ServiceDataFlowTemplateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceDataFlowTemplateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceDataFlowTemplates = mapped
    }

    /**
     * @param argument The set of data flow templates to use for this data flow policy rule.
     */
    @JvmName("kvgmrlmersieyjnc")
    public suspend
    fun serviceDataFlowTemplates(argument: suspend ServiceDataFlowTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceDataFlowTemplateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.serviceDataFlowTemplates = mapped
    }

    /**
     * @param values The set of data flow templates to use for this data flow policy rule.
     */
    @JvmName("ugqfffxqlbtdbqqk")
    public suspend fun serviceDataFlowTemplates(vararg values: ServiceDataFlowTemplateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceDataFlowTemplates = mapped
    }

    /**
     * @param value Determines whether flows that match this data flow policy rule are permitted.
     */
    @JvmName("vbvwatkhtsyenhxv")
    public suspend fun trafficControl(`value`: Either<String, TrafficControlPermission>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficControl = mapped
    }

    /**
     * @param value Determines whether flows that match this data flow policy rule are permitted.
     */
    @JvmName("swhlknkwdvippvff")
    public fun trafficControl(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TrafficControlPermission>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trafficControl = mapped
    }

    /**
     * @param value Determines whether flows that match this data flow policy rule are permitted.
     */
    @JvmName("yvwchusvxjbmansw")
    public fun trafficControl(`value`: TrafficControlPermission) {
        val toBeMapped = Either.ofRight<String, TrafficControlPermission>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trafficControl = mapped
    }

    internal fun build(): PccRuleConfigurationArgs = PccRuleConfigurationArgs(
        ruleName = ruleName ?: throw PulumiNullFieldException("ruleName"),
        rulePrecedence = rulePrecedence ?: throw PulumiNullFieldException("rulePrecedence"),
        ruleQosPolicy = ruleQosPolicy,
        serviceDataFlowTemplates = serviceDataFlowTemplates ?: throw
            PulumiNullFieldException("serviceDataFlowTemplates"),
        trafficControl = trafficControl,
    )
}
