@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.PortReuseHoldTimesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The minimum time (in seconds) that will pass before a port that was used by a closed pinhole can be recycled for use by another pinhole. All hold times must be minimum 1 second.
 * @property tcp Minimum time in seconds that will pass before a TCP port that was used by a closed pinhole can be reused. Default for TCP is 2 minutes.
 * @property udp Minimum time in seconds that will pass before a UDP port that was used by a closed pinhole can be reused. Default for UDP is 1 minute.
 */
public data class PortReuseHoldTimesArgs(
    public val tcp: Output<Int>? = null,
    public val udp: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.PortReuseHoldTimesArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.PortReuseHoldTimesArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.PortReuseHoldTimesArgs.builder()
            .tcp(tcp?.applyValue({ args0 -> args0 }))
            .udp(udp?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PortReuseHoldTimesArgs].
 */
@PulumiTagMarker
public class PortReuseHoldTimesArgsBuilder internal constructor() {
    private var tcp: Output<Int>? = null

    private var udp: Output<Int>? = null

    /**
     * @param value Minimum time in seconds that will pass before a TCP port that was used by a closed pinhole can be reused. Default for TCP is 2 minutes.
     */
    @JvmName("akgjipjnvicioeht")
    public suspend fun tcp(`value`: Output<Int>) {
        this.tcp = value
    }

    /**
     * @param value Minimum time in seconds that will pass before a UDP port that was used by a closed pinhole can be reused. Default for UDP is 1 minute.
     */
    @JvmName("qdphnahxrtniqkjq")
    public suspend fun udp(`value`: Output<Int>) {
        this.udp = value
    }

    /**
     * @param value Minimum time in seconds that will pass before a TCP port that was used by a closed pinhole can be reused. Default for TCP is 2 minutes.
     */
    @JvmName("deqgekxajsrlthtm")
    public suspend fun tcp(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcp = mapped
    }

    /**
     * @param value Minimum time in seconds that will pass before a UDP port that was used by a closed pinhole can be reused. Default for UDP is 1 minute.
     */
    @JvmName("pmksiusaiivhkgtv")
    public suspend fun udp(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.udp = mapped
    }

    internal fun build(): PortReuseHoldTimesArgs = PortReuseHoldTimesArgs(
        tcp = tcp,
        udp = udp,
    )
}
