@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.ServiceDataFlowTemplateArgs.builder
import com.pulumi.azurenative.mobilenetwork.kotlin.enums.SdfDirection
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Data flow template
 * @property direction The direction of this flow.
 * @property ports The port(s) to which UEs will connect for this flow. You can specify zero or more ports or port ranges. If you specify one or more ports or port ranges then you must specify a value other than `ip` in the `protocol` field. This is an optional setting. If you do not specify it then connections will be allowed on all ports. Port ranges must be specified as <FirstPort>-<LastPort>. For example: [`8080`, `8082-8085`].
 * @property protocol A list of the allowed protocol(s) for this flow. If you want this flow to be able to use any protocol within the internet protocol suite, use the value `ip`. If you only want to allow a selection of protocols, you must use the corresponding IANA Assigned Internet Protocol Number for each protocol, as described in https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml. For example, for UDP, you must use 17. If you use the value `ip` then you must leave the field `port` unspecified.
 * @property remoteIpList The remote IP address(es) to which UEs will connect for this flow. If you want to allow connections on any IP address, use the value `any`. Otherwise, you must provide each of the remote IP addresses to which the packet core instance will connect for this flow. You must provide each IP address in CIDR notation, including the netmask (for example, 192.0.2.54/24).
 * @property templateName The name of the data flow template. This must be unique within the parent data flow policy rule. You must not use any of the following reserved strings - `default`, `requested` or `service`.
 */
public data class ServiceDataFlowTemplateArgs(
    public val direction: Output<Either<String, SdfDirection>>,
    public val ports: Output<List<String>>? = null,
    public val protocol: Output<List<String>>,
    public val remoteIpList: Output<List<String>>,
    public val templateName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.ServiceDataFlowTemplateArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.ServiceDataFlowTemplateArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.ServiceDataFlowTemplateArgs.builder()
            .direction(
                direction.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ports(ports?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .protocol(protocol.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .remoteIpList(remoteIpList.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .templateName(templateName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceDataFlowTemplateArgs].
 */
@PulumiTagMarker
public class ServiceDataFlowTemplateArgsBuilder internal constructor() {
    private var direction: Output<Either<String, SdfDirection>>? = null

    private var ports: Output<List<String>>? = null

    private var protocol: Output<List<String>>? = null

    private var remoteIpList: Output<List<String>>? = null

    private var templateName: Output<String>? = null

    /**
     * @param value The direction of this flow.
     */
    @JvmName("wuhaqpledfgpbogt")
    public suspend fun direction(`value`: Output<Either<String, SdfDirection>>) {
        this.direction = value
    }

    /**
     * @param value The port(s) to which UEs will connect for this flow. You can specify zero or more ports or port ranges. If you specify one or more ports or port ranges then you must specify a value other than `ip` in the `protocol` field. This is an optional setting. If you do not specify it then connections will be allowed on all ports. Port ranges must be specified as <FirstPort>-<LastPort>. For example: [`8080`, `8082-8085`].
     */
    @JvmName("oklgxfafnjkvjudd")
    public suspend fun ports(`value`: Output<List<String>>) {
        this.ports = value
    }

    @JvmName("qymxiibbuggbrikn")
    public suspend fun ports(vararg values: Output<String>) {
        this.ports = Output.all(values.asList())
    }

    /**
     * @param values The port(s) to which UEs will connect for this flow. You can specify zero or more ports or port ranges. If you specify one or more ports or port ranges then you must specify a value other than `ip` in the `protocol` field. This is an optional setting. If you do not specify it then connections will be allowed on all ports. Port ranges must be specified as <FirstPort>-<LastPort>. For example: [`8080`, `8082-8085`].
     */
    @JvmName("bembnjjafnwedpwn")
    public suspend fun ports(values: List<Output<String>>) {
        this.ports = Output.all(values)
    }

    /**
     * @param value A list of the allowed protocol(s) for this flow. If you want this flow to be able to use any protocol within the internet protocol suite, use the value `ip`. If you only want to allow a selection of protocols, you must use the corresponding IANA Assigned Internet Protocol Number for each protocol, as described in https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml. For example, for UDP, you must use 17. If you use the value `ip` then you must leave the field `port` unspecified.
     */
    @JvmName("mtghttqwcjvxslen")
    public suspend fun protocol(`value`: Output<List<String>>) {
        this.protocol = value
    }

    @JvmName("vevkonpbcyhdoyve")
    public suspend fun protocol(vararg values: Output<String>) {
        this.protocol = Output.all(values.asList())
    }

    /**
     * @param values A list of the allowed protocol(s) for this flow. If you want this flow to be able to use any protocol within the internet protocol suite, use the value `ip`. If you only want to allow a selection of protocols, you must use the corresponding IANA Assigned Internet Protocol Number for each protocol, as described in https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml. For example, for UDP, you must use 17. If you use the value `ip` then you must leave the field `port` unspecified.
     */
    @JvmName("qnvvpogjrmuevtne")
    public suspend fun protocol(values: List<Output<String>>) {
        this.protocol = Output.all(values)
    }

    /**
     * @param value The remote IP address(es) to which UEs will connect for this flow. If you want to allow connections on any IP address, use the value `any`. Otherwise, you must provide each of the remote IP addresses to which the packet core instance will connect for this flow. You must provide each IP address in CIDR notation, including the netmask (for example, 192.0.2.54/24).
     */
    @JvmName("mqjiruxenwoouaqh")
    public suspend fun remoteIpList(`value`: Output<List<String>>) {
        this.remoteIpList = value
    }

    @JvmName("jnuneybriwmcokmf")
    public suspend fun remoteIpList(vararg values: Output<String>) {
        this.remoteIpList = Output.all(values.asList())
    }

    /**
     * @param values The remote IP address(es) to which UEs will connect for this flow. If you want to allow connections on any IP address, use the value `any`. Otherwise, you must provide each of the remote IP addresses to which the packet core instance will connect for this flow. You must provide each IP address in CIDR notation, including the netmask (for example, 192.0.2.54/24).
     */
    @JvmName("wyeanpfwgffwgruq")
    public suspend fun remoteIpList(values: List<Output<String>>) {
        this.remoteIpList = Output.all(values)
    }

    /**
     * @param value The name of the data flow template. This must be unique within the parent data flow policy rule. You must not use any of the following reserved strings - `default`, `requested` or `service`.
     */
    @JvmName("mtyjovgmucatmohj")
    public suspend fun templateName(`value`: Output<String>) {
        this.templateName = value
    }

    /**
     * @param value The direction of this flow.
     */
    @JvmName("iwubddhjsyniwrgo")
    public suspend fun direction(`value`: Either<String, SdfDirection>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The direction of this flow.
     */
    @JvmName("tjvflvxptcgdmhpc")
    public fun direction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SdfDirection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The direction of this flow.
     */
    @JvmName("ydcjnowtpwbqxocl")
    public fun direction(`value`: SdfDirection) {
        val toBeMapped = Either.ofRight<String, SdfDirection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value The port(s) to which UEs will connect for this flow. You can specify zero or more ports or port ranges. If you specify one or more ports or port ranges then you must specify a value other than `ip` in the `protocol` field. This is an optional setting. If you do not specify it then connections will be allowed on all ports. Port ranges must be specified as <FirstPort>-<LastPort>. For example: [`8080`, `8082-8085`].
     */
    @JvmName("qvngvfsfmqrgrcya")
    public suspend fun ports(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param values The port(s) to which UEs will connect for this flow. You can specify zero or more ports or port ranges. If you specify one or more ports or port ranges then you must specify a value other than `ip` in the `protocol` field. This is an optional setting. If you do not specify it then connections will be allowed on all ports. Port ranges must be specified as <FirstPort>-<LastPort>. For example: [`8080`, `8082-8085`].
     */
    @JvmName("ukumlitruoddtppc")
    public suspend fun ports(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param value A list of the allowed protocol(s) for this flow. If you want this flow to be able to use any protocol within the internet protocol suite, use the value `ip`. If you only want to allow a selection of protocols, you must use the corresponding IANA Assigned Internet Protocol Number for each protocol, as described in https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml. For example, for UDP, you must use 17. If you use the value `ip` then you must leave the field `port` unspecified.
     */
    @JvmName("ivprxucbtfsqulrv")
    public suspend fun protocol(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param values A list of the allowed protocol(s) for this flow. If you want this flow to be able to use any protocol within the internet protocol suite, use the value `ip`. If you only want to allow a selection of protocols, you must use the corresponding IANA Assigned Internet Protocol Number for each protocol, as described in https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml. For example, for UDP, you must use 17. If you use the value `ip` then you must leave the field `port` unspecified.
     */
    @JvmName("walnevrvcgmwbquu")
    public suspend fun protocol(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The remote IP address(es) to which UEs will connect for this flow. If you want to allow connections on any IP address, use the value `any`. Otherwise, you must provide each of the remote IP addresses to which the packet core instance will connect for this flow. You must provide each IP address in CIDR notation, including the netmask (for example, 192.0.2.54/24).
     */
    @JvmName("axbixhjrsmudjjha")
    public suspend fun remoteIpList(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.remoteIpList = mapped
    }

    /**
     * @param values The remote IP address(es) to which UEs will connect for this flow. If you want to allow connections on any IP address, use the value `any`. Otherwise, you must provide each of the remote IP addresses to which the packet core instance will connect for this flow. You must provide each IP address in CIDR notation, including the netmask (for example, 192.0.2.54/24).
     */
    @JvmName("umsgtsixvpstxqpo")
    public suspend fun remoteIpList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.remoteIpList = mapped
    }

    /**
     * @param value The name of the data flow template. This must be unique within the parent data flow policy rule. You must not use any of the following reserved strings - `default`, `requested` or `service`.
     */
    @JvmName("gvyyaditamrgijxi")
    public suspend fun templateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.templateName = mapped
    }

    internal fun build(): ServiceDataFlowTemplateArgs = ServiceDataFlowTemplateArgs(
        direction = direction ?: throw PulumiNullFieldException("direction"),
        ports = ports,
        protocol = protocol ?: throw PulumiNullFieldException("protocol"),
        remoteIpList = remoteIpList ?: throw PulumiNullFieldException("remoteIpList"),
        templateName = templateName ?: throw PulumiNullFieldException("templateName"),
    )
}
