@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.SimPolicyResourceIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Reference to a SIM policy resource.
 * @property id SIM policy resource ID.
 */
public data class SimPolicyResourceIdArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.SimPolicyResourceIdArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.SimPolicyResourceIdArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.SimPolicyResourceIdArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SimPolicyResourceIdArgs].
 */
@PulumiTagMarker
public class SimPolicyResourceIdArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value SIM policy resource ID.
     */
    @JvmName("ieatblrbjbsemgve")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value SIM policy resource ID.
     */
    @JvmName("hxhyoavqdidpqxnn")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): SimPolicyResourceIdArgs = SimPolicyResourceIdArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
