@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.inputs

import com.pulumi.azurenative.mobilenetwork.inputs.SiteResourceIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Reference to a site resource.
 * @property id Site resource ID.
 */
public data class SiteResourceIdArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.mobilenetwork.inputs.SiteResourceIdArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilenetwork.inputs.SiteResourceIdArgs =
        com.pulumi.azurenative.mobilenetwork.inputs.SiteResourceIdArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SiteResourceIdArgs].
 */
@PulumiTagMarker
public class SiteResourceIdArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Site resource ID.
     */
    @JvmName("nsfhjosinjtdqusp")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Site resource ID.
     */
    @JvmName("vktthoyylqwnmooa")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): SiteResourceIdArgs = SiteResourceIdArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
