@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Packet core control plane resource.
 * @property controlPlaneAccessInterface The control plane interface on the access network. For 5G networks, this is the N2 interface. For 4G networks, this is the S1-MME interface.
 * @property coreNetworkTechnology The core network technology generation (5G core or EPC / 4G core).
 * @property diagnosticsUpload Configuration for uploading packet core diagnostics
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property identity The identity used to retrieve the ingress certificate from Azure key vault.
 * @property installation The installation state of the packet core control plane resource.
 * @property installedVersion The currently installed version of the packet core software.
 * @property interopSettings Settings to allow interoperability with third party components e.g. RANs and UEs.
 * @property localDiagnosticsAccess The kubernetes ingress configuration to control access to packet core diagnostics over local APIs.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property platform The platform where the packet core is deployed.
 * @property provisioningState The provisioning state of the packet core control plane resource.
 * @property rollbackVersion The previous version of the packet core software that was deployed. Used when performing the rollback action.
 * @property sites Site(s) under which this packet core control plane should be deployed. The sites must be in the same location as the packet core control plane.
 * @property sku The SKU defining the throughput and SIM allowances for this packet core control plane deployment.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property ueMtu The MTU (in bytes) signaled to the UE. The same MTU is set on the user plane data links for all data networks. The MTU set on the user plane access link is calculated to be 60 bytes greater than this value to allow for GTP encapsulation.
 * @property version The desired version of the packet core software.
 */
public data class GetPacketCoreControlPlaneResult(
    public val controlPlaneAccessInterface: InterfacePropertiesResponse,
    public val coreNetworkTechnology: String? = null,
    public val diagnosticsUpload: DiagnosticsUploadConfigurationResponse? = null,
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val installation: InstallationResponse? = null,
    public val installedVersion: String,
    public val interopSettings: Any? = null,
    public val localDiagnosticsAccess: LocalDiagnosticsAccessConfigurationResponse,
    public val location: String,
    public val name: String,
    public val platform: PlatformConfigurationResponse,
    public val provisioningState: String,
    public val rollbackVersion: String,
    public val sites: List<SiteResourceIdResponse>,
    public val sku: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val ueMtu: Int? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.GetPacketCoreControlPlaneResult):
            GetPacketCoreControlPlaneResult = GetPacketCoreControlPlaneResult(
            controlPlaneAccessInterface = javaType.controlPlaneAccessInterface().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.InterfacePropertiesResponse.Companion.toKotlin(args0)
            }),
            coreNetworkTechnology = javaType.coreNetworkTechnology().map({ args0 -> args0 }).orElse(null),
            diagnosticsUpload = javaType.diagnosticsUpload().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.DiagnosticsUploadConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            installation = javaType.installation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.InstallationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            installedVersion = javaType.installedVersion(),
            interopSettings = javaType.interopSettings().map({ args0 -> args0 }).orElse(null),
            localDiagnosticsAccess = javaType.localDiagnosticsAccess().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.LocalDiagnosticsAccessConfigurationResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location(),
            name = javaType.name(),
            platform = javaType.platform().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.PlatformConfigurationResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
            rollbackVersion = javaType.rollbackVersion(),
            sites = javaType.sites().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SiteResourceIdResponse.Companion.toKotlin(args0)
                })
            }),
            sku = javaType.sku(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.mobilenetwork.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            ueMtu = javaType.ueMtu().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
