@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilenetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The kubernetes ingress configuration to control access to packet core diagnostics over local APIs.
 * @property authenticationType How to authenticate users who access local diagnostics APIs.
 * @property httpsServerCertificate The HTTPS server TLS certificate used to secure local access to diagnostics.
 */
public data class LocalDiagnosticsAccessConfigurationResponse(
    public val authenticationType: String,
    public val httpsServerCertificate: HttpsServerCertificateResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.mobilenetwork.outputs.LocalDiagnosticsAccessConfigurationResponse):
            LocalDiagnosticsAccessConfigurationResponse = LocalDiagnosticsAccessConfigurationResponse(
            authenticationType = javaType.authenticationType(),
            httpsServerCertificate = javaType.httpsServerCertificate().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.mobilenetwork.kotlin.outputs.HttpsServerCertificateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
