@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.inputs

import com.pulumi.azurenative.mobilepacketcore.inputs.GetAmfDeploymentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property amfDeploymentName The name of the AMF Deployment
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAmfDeploymentPlainArgs(
    public val amfDeploymentName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.inputs.GetAmfDeploymentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilepacketcore.inputs.GetAmfDeploymentPlainArgs =
        com.pulumi.azurenative.mobilepacketcore.inputs.GetAmfDeploymentPlainArgs.builder()
            .amfDeploymentName(amfDeploymentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAmfDeploymentPlainArgs].
 */
@PulumiTagMarker
public class GetAmfDeploymentPlainArgsBuilder internal constructor() {
    private var amfDeploymentName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the AMF Deployment
     */
    @JvmName("dxsgcdhjqnnpnxkv")
    public suspend fun amfDeploymentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.amfDeploymentName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vxbunvhkkdoceyts")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAmfDeploymentPlainArgs = GetAmfDeploymentPlainArgs(
        amfDeploymentName = amfDeploymentName ?: throw PulumiNullFieldException("amfDeploymentName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
