@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.inputs

import com.pulumi.azurenative.mobilepacketcore.inputs.GetClusterServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterServiceName The name of the Cluster Service
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetClusterServicePlainArgs(
    public val clusterServiceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.mobilepacketcore.inputs.GetClusterServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.mobilepacketcore.inputs.GetClusterServicePlainArgs =
        com.pulumi.azurenative.mobilepacketcore.inputs.GetClusterServicePlainArgs.builder()
            .clusterServiceName(clusterServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetClusterServicePlainArgs].
 */
@PulumiTagMarker
public class GetClusterServicePlainArgsBuilder internal constructor() {
    private var clusterServiceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Cluster Service
     */
    @JvmName("sylucymptktdilen")
    public suspend fun clusterServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterServiceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vfhugnlsbfavmqnu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetClusterServicePlainArgs = GetClusterServicePlainArgs(
        clusterServiceName = clusterServiceName ?: throw PulumiNullFieldException("clusterServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
