@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Nexus AKS Cluster specific data.
 * @property customLocationId Custom Location resource ID
 * @property type Cluster Type Definitions
 * Expected value is 'NexusAks'.
 */
public data class ClusterServiceNexusAksClusterDataResponse(
    public val customLocationId: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.mobilepacketcore.outputs.ClusterServiceNexusAksClusterDataResponse):
            ClusterServiceNexusAksClusterDataResponse = ClusterServiceNexusAksClusterDataResponse(
            customLocationId = javaType.customLocationId(),
            type = javaType.type(),
        )
    }
}
