@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.mobilepacketcore.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Azure for Operators 5G Core User Plane Function (UPF) Deployment Resource
 * @property clusterService Reference to cluster where the Network Function is deployed
 * @property componentParameters Azure for Operators 5G Core UPF component parameters
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property operationalStatus Operational status
 * @property provisioningState The status of the last operation.
 * @property releaseVersion Release version. This is inherited from the cluster
 * @property secretsParameters Azure for Operators 5G Core F secrets parameters
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetUpfDeploymentResult(
    public val clusterService: String,
    public val componentParameters: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val operationalStatus: OperationalStatusResponse,
    public val provisioningState: String,
    public val releaseVersion: String,
    public val secretsParameters: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.mobilepacketcore.outputs.GetUpfDeploymentResult):
            GetUpfDeploymentResult = GetUpfDeploymentResult(
            clusterService = javaType.clusterService(),
            componentParameters = javaType.componentParameters(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            operationalStatus = javaType.operationalStatus().let({ args0 ->
                com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.OperationalStatusResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
            releaseVersion = javaType.releaseVersion(),
            secretsParameters = javaType.secretsParameters().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.mobilepacketcore.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
