@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.monitor.kotlin

import com.pulumi.azurenative.monitor.MonitorFunctions.getAzureMonitorWorkspacePlain
import com.pulumi.azurenative.monitor.kotlin.inputs.GetAzureMonitorWorkspacePlainArgs
import com.pulumi.azurenative.monitor.kotlin.inputs.GetAzureMonitorWorkspacePlainArgsBuilder
import com.pulumi.azurenative.monitor.kotlin.outputs.GetAzureMonitorWorkspaceResult
import com.pulumi.azurenative.monitor.kotlin.outputs.GetAzureMonitorWorkspaceResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object MonitorFunctions {
    /**
     * Returns the specified Azure Monitor Workspace
     * Azure REST API version: 2023-04-03.
     * @param argument null
     * @return An Azure Monitor Workspace definition
     */
    public suspend fun getAzureMonitorWorkspace(argument: GetAzureMonitorWorkspacePlainArgs):
        GetAzureMonitorWorkspaceResult =
        toKotlin(getAzureMonitorWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getAzureMonitorWorkspace].
     * @param azureMonitorWorkspaceName The name of the Azure Monitor Workspace. The name is case insensitive
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Azure Monitor Workspace definition
     */
    public suspend fun getAzureMonitorWorkspace(
        azureMonitorWorkspaceName: String,
        resourceGroupName: String,
    ): GetAzureMonitorWorkspaceResult {
        val argument = GetAzureMonitorWorkspacePlainArgs(
            azureMonitorWorkspaceName = azureMonitorWorkspaceName,
            resourceGroupName = resourceGroupName,
        )
        return toKotlin(getAzureMonitorWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getAzureMonitorWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;monitor&#46;kotlin&#46;inputs&#46;GetAzureMonitorWorkspacePlainArgs].
     * @return An Azure Monitor Workspace definition
     */
    public suspend
    fun getAzureMonitorWorkspace(argument: suspend GetAzureMonitorWorkspacePlainArgsBuilder.() -> Unit):
        GetAzureMonitorWorkspaceResult {
        val builder = GetAzureMonitorWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getAzureMonitorWorkspacePlain(builtArgument.toJava()).await())
    }
}
