@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Backup].
 */
@PulumiTagMarker
public class BackupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BackupArgs = BackupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BackupArgsBuilder.() -> Unit) {
        val builder = BackupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Backup {
        val builtJavaResource = com.pulumi.azurenative.netapp.Backup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Backup(builtJavaResource)
    }
}

/**
 * Backup of a Volume
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-11-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Backups_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backup = new AzureNative.NetApp.Backup("backup", new()
 *     {
 *         AccountName = "account1",
 *         BackupName = "backup1",
 *         Label = "myLabel",
 *         Location = "eastus",
 *         PoolName = "pool1",
 *         ResourceGroupName = "myRG",
 *         VolumeName = "volume1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewBackup(ctx, "backup", &netapp.BackupArgs{
 * 			AccountName:       pulumi.String("account1"),
 * 			BackupName:        pulumi.String("backup1"),
 * 			Label:             pulumi.String("myLabel"),
 * 			Location:          pulumi.String("eastus"),
 * 			PoolName:          pulumi.String("pool1"),
 * 			ResourceGroupName: pulumi.String("myRG"),
 * 			VolumeName:        pulumi.String("volume1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.Backup;
 * import com.pulumi.azurenative.netapp.BackupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backup = new Backup("backup", BackupArgs.builder()
 *             .accountName("account1")
 *             .backupName("backup1")
 *             .label("myLabel")
 *             .location("eastus")
 *             .poolName("pool1")
 *             .resourceGroupName("myRG")
 *             .volumeName("volume1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:Backup account1/pool1/volume1/backup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}/backups/{backupName}
 * ```
 */
public class Backup internal constructor(
    override val javaResource: com.pulumi.azurenative.netapp.Backup,
) : KotlinCustomResource(javaResource, BackupMapper) {
    /**
     * UUID v4 used to identify the Backup
     */
    public val backupId: Output<String>
        get() = javaResource.backupId().applyValue({ args0 -> args0 })

    /**
     * Type of backup Manual or Scheduled
     */
    public val backupType: Output<String>
        get() = javaResource.backupType().applyValue({ args0 -> args0 })

    /**
     * The creation date of the backup
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * Failure reason
     */
    public val failureReason: Output<String>
        get() = javaResource.failureReason().applyValue({ args0 -> args0 })

    /**
     * Label for backup
     */
    public val label: Output<String>?
        get() = javaResource.label().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure lifecycle management
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Size of backup
     */
    public val size: Output<Double>
        get() = javaResource.size().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Manual backup an already existing snapshot. This will always be false for scheduled backups and true/false for manual backups
     */
    public val useExistingSnapshot: Output<Boolean>?
        get() = javaResource.useExistingSnapshot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Volume name
     */
    public val volumeName: Output<String>
        get() = javaResource.volumeName().applyValue({ args0 -> args0 })
}

public object BackupMapper : ResourceMapper<Backup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.netapp.Backup::class == javaResource::class

    override fun map(javaResource: Resource): Backup = Backup(
        javaResource as
            com.pulumi.azurenative.netapp.Backup,
    )
}

/**
 * @see [Backup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Backup].
 */
public suspend fun backup(name: String, block: suspend BackupResourceBuilder.() -> Unit): Backup {
    val builder = BackupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Backup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun backup(name: String): Backup {
    val builder = BackupResourceBuilder()
    builder.name(name)
    return builder.build()
}
