@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.NetappFunctions.getAccountPlain
import com.pulumi.azurenative.netapp.NetappFunctions.getBackupPlain
import com.pulumi.azurenative.netapp.NetappFunctions.getBackupPolicyPlain
import com.pulumi.azurenative.netapp.NetappFunctions.getBackupVaultPlain
import com.pulumi.azurenative.netapp.NetappFunctions.getPoolPlain
import com.pulumi.azurenative.netapp.NetappFunctions.getSnapshotPlain
import com.pulumi.azurenative.netapp.NetappFunctions.getSnapshotPolicyPlain
import com.pulumi.azurenative.netapp.NetappFunctions.getSubvolumeMetadataPlain
import com.pulumi.azurenative.netapp.NetappFunctions.getSubvolumePlain
import com.pulumi.azurenative.netapp.NetappFunctions.getVolumeGroupIdForLdapUserPlain
import com.pulumi.azurenative.netapp.NetappFunctions.getVolumeGroupPlain
import com.pulumi.azurenative.netapp.NetappFunctions.getVolumePlain
import com.pulumi.azurenative.netapp.NetappFunctions.getVolumeQuotaRulePlain
import com.pulumi.azurenative.netapp.NetappFunctions.listVolumeReplicationsPlain
import com.pulumi.azurenative.netapp.kotlin.inputs.GetAccountPlainArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.GetAccountPlainArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.GetBackupPlainArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.GetBackupPlainArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.GetBackupPolicyPlainArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.GetBackupPolicyPlainArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.GetBackupVaultPlainArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.GetBackupVaultPlainArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.GetPoolPlainArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.GetPoolPlainArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.GetSnapshotPlainArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.GetSnapshotPlainArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.GetSnapshotPolicyPlainArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.GetSnapshotPolicyPlainArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.GetSubvolumeMetadataPlainArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.GetSubvolumeMetadataPlainArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.GetSubvolumePlainArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.GetSubvolumePlainArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.GetVolumeGroupIdForLdapUserPlainArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.GetVolumeGroupIdForLdapUserPlainArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.GetVolumeGroupPlainArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.GetVolumeGroupPlainArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.GetVolumePlainArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.GetVolumePlainArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.GetVolumeQuotaRulePlainArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.GetVolumeQuotaRulePlainArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.ListVolumeReplicationsPlainArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.ListVolumeReplicationsPlainArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.outputs.GetAccountResult
import com.pulumi.azurenative.netapp.kotlin.outputs.GetBackupPolicyResult
import com.pulumi.azurenative.netapp.kotlin.outputs.GetBackupResult
import com.pulumi.azurenative.netapp.kotlin.outputs.GetBackupVaultResult
import com.pulumi.azurenative.netapp.kotlin.outputs.GetPoolResult
import com.pulumi.azurenative.netapp.kotlin.outputs.GetSnapshotPolicyResult
import com.pulumi.azurenative.netapp.kotlin.outputs.GetSnapshotResult
import com.pulumi.azurenative.netapp.kotlin.outputs.GetSubvolumeMetadataResult
import com.pulumi.azurenative.netapp.kotlin.outputs.GetSubvolumeResult
import com.pulumi.azurenative.netapp.kotlin.outputs.GetVolumeGroupIdForLdapUserResult
import com.pulumi.azurenative.netapp.kotlin.outputs.GetVolumeGroupResult
import com.pulumi.azurenative.netapp.kotlin.outputs.GetVolumeQuotaRuleResult
import com.pulumi.azurenative.netapp.kotlin.outputs.GetVolumeResult
import com.pulumi.azurenative.netapp.kotlin.outputs.ListVolumeReplicationsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.netapp.kotlin.outputs.GetAccountResult.Companion.toKotlin as getAccountResultToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.GetBackupPolicyResult.Companion.toKotlin as getBackupPolicyResultToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.GetBackupResult.Companion.toKotlin as getBackupResultToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.GetBackupVaultResult.Companion.toKotlin as getBackupVaultResultToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.GetPoolResult.Companion.toKotlin as getPoolResultToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.GetSnapshotPolicyResult.Companion.toKotlin as getSnapshotPolicyResultToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.GetSnapshotResult.Companion.toKotlin as getSnapshotResultToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.GetSubvolumeMetadataResult.Companion.toKotlin as getSubvolumeMetadataResultToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.GetSubvolumeResult.Companion.toKotlin as getSubvolumeResultToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.GetVolumeGroupIdForLdapUserResult.Companion.toKotlin as getVolumeGroupIdForLdapUserResultToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.GetVolumeGroupResult.Companion.toKotlin as getVolumeGroupResultToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.GetVolumeQuotaRuleResult.Companion.toKotlin as getVolumeQuotaRuleResultToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.GetVolumeResult.Companion.toKotlin as getVolumeResultToKotlin
import com.pulumi.azurenative.netapp.kotlin.outputs.ListVolumeReplicationsResult.Companion.toKotlin as listVolumeReplicationsResultToKotlin

public object NetappFunctions {
    /**
     * Get the NetApp account
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2019-07-01, 2022-05-01, 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01.
     * @param argument null
     * @return NetApp account resource
     */
    public suspend fun getAccount(argument: GetAccountPlainArgs): GetAccountResult =
        getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())

    /**
     * @see [getAccount].
     * @param accountName The name of the NetApp account
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return NetApp account resource
     */
    public suspend fun getAccount(accountName: String, resourceGroupName: String): GetAccountResult {
        val argument = GetAccountPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;netapp&#46;kotlin&#46;inputs&#46;GetAccountPlainArgs].
     * @return NetApp account resource
     */
    public suspend fun getAccount(argument: suspend GetAccountPlainArgsBuilder.() -> Unit):
        GetAccountResult {
        val builder = GetAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountResultToKotlin(getAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the specified backup of the volume
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Backup of a Volume
     */
    public suspend fun getBackup(argument: GetBackupPlainArgs): GetBackupResult =
        getBackupResultToKotlin(getBackupPlain(argument.toJava()).await())

    /**
     * @see [getBackup].
     * @param accountName The name of the NetApp account
     * @param backupName The name of the backup
     * @param poolName The name of the capacity pool
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param volumeName The name of the volume
     * @return Backup of a Volume
     */
    public suspend fun getBackup(
        accountName: String,
        backupName: String,
        poolName: String,
        resourceGroupName: String,
        volumeName: String,
    ): GetBackupResult {
        val argument = GetBackupPlainArgs(
            accountName = accountName,
            backupName = backupName,
            poolName = poolName,
            resourceGroupName = resourceGroupName,
            volumeName = volumeName,
        )
        return getBackupResultToKotlin(getBackupPlain(argument.toJava()).await())
    }

    /**
     * @see [getBackup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;netapp&#46;kotlin&#46;inputs&#46;GetBackupPlainArgs].
     * @return Backup of a Volume
     */
    public suspend fun getBackup(argument: suspend GetBackupPlainArgsBuilder.() -> Unit):
        GetBackupResult {
        val builder = GetBackupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBackupResultToKotlin(getBackupPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a particular backup Policy
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2021-04-01, 2021-04-01-preview, 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01.
     * @param argument null
     * @return Backup policy information
     */
    public suspend fun getBackupPolicy(argument: GetBackupPolicyPlainArgs): GetBackupPolicyResult =
        getBackupPolicyResultToKotlin(getBackupPolicyPlain(argument.toJava()).await())

    /**
     * @see [getBackupPolicy].
     * @param accountName The name of the NetApp account
     * @param backupPolicyName Backup policy Name which uniquely identify backup policy.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Backup policy information
     */
    public suspend fun getBackupPolicy(
        accountName: String,
        backupPolicyName: String,
        resourceGroupName: String,
    ): GetBackupPolicyResult {
        val argument = GetBackupPolicyPlainArgs(
            accountName = accountName,
            backupPolicyName = backupPolicyName,
            resourceGroupName = resourceGroupName,
        )
        return getBackupPolicyResultToKotlin(getBackupPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getBackupPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;netapp&#46;kotlin&#46;inputs&#46;GetBackupPolicyPlainArgs].
     * @return Backup policy information
     */
    public suspend fun getBackupPolicy(argument: suspend GetBackupPolicyPlainArgsBuilder.() -> Unit):
        GetBackupPolicyResult {
        val builder = GetBackupPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBackupPolicyResultToKotlin(getBackupPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the Backup Vault
     * Azure REST API version: 2022-11-01-preview.
     * Other available API versions: 2023-05-01-preview.
     * @param argument null
     * @return Backup Vault information
     */
    public suspend fun getBackupVault(argument: GetBackupVaultPlainArgs): GetBackupVaultResult =
        getBackupVaultResultToKotlin(getBackupVaultPlain(argument.toJava()).await())

    /**
     * @see [getBackupVault].
     * @param accountName The name of the NetApp account
     * @param backupVaultName The name of the Backup Vault
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Backup Vault information
     */
    public suspend fun getBackupVault(
        accountName: String,
        backupVaultName: String,
        resourceGroupName: String,
    ): GetBackupVaultResult {
        val argument = GetBackupVaultPlainArgs(
            accountName = accountName,
            backupVaultName = backupVaultName,
            resourceGroupName = resourceGroupName,
        )
        return getBackupVaultResultToKotlin(getBackupVaultPlain(argument.toJava()).await())
    }

    /**
     * @see [getBackupVault].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;netapp&#46;kotlin&#46;inputs&#46;GetBackupVaultPlainArgs].
     * @return Backup Vault information
     */
    public suspend fun getBackupVault(argument: suspend GetBackupVaultPlainArgsBuilder.() -> Unit):
        GetBackupVaultResult {
        val builder = GetBackupVaultPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBackupVaultResultToKotlin(getBackupVaultPlain(builtArgument.toJava()).await())
    }

    /**
     * Get details of the specified capacity pool
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2017-08-15, 2019-07-01, 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01.
     * @param argument null
     * @return Capacity pool resource
     */
    public suspend fun getPool(argument: GetPoolPlainArgs): GetPoolResult =
        getPoolResultToKotlin(getPoolPlain(argument.toJava()).await())

    /**
     * @see [getPool].
     * @param accountName The name of the NetApp account
     * @param poolName The name of the capacity pool
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Capacity pool resource
     */
    public suspend fun getPool(
        accountName: String,
        poolName: String,
        resourceGroupName: String,
    ): GetPoolResult {
        val argument = GetPoolPlainArgs(
            accountName = accountName,
            poolName = poolName,
            resourceGroupName = resourceGroupName,
        )
        return getPoolResultToKotlin(getPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;netapp&#46;kotlin&#46;inputs&#46;GetPoolPlainArgs].
     * @return Capacity pool resource
     */
    public suspend fun getPool(argument: suspend GetPoolPlainArgsBuilder.() -> Unit): GetPoolResult {
        val builder = GetPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPoolResultToKotlin(getPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Get details of the specified snapshot
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2017-08-15, 2019-06-01, 2019-10-01, 2019-11-01, 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01.
     * @param argument null
     * @return Snapshot of a Volume
     */
    public suspend fun getSnapshot(argument: GetSnapshotPlainArgs): GetSnapshotResult =
        getSnapshotResultToKotlin(getSnapshotPlain(argument.toJava()).await())

    /**
     * @see [getSnapshot].
     * @param accountName The name of the NetApp account
     * @param poolName The name of the capacity pool
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param snapshotName The name of the snapshot
     * @param volumeName The name of the volume
     * @return Snapshot of a Volume
     */
    public suspend fun getSnapshot(
        accountName: String,
        poolName: String,
        resourceGroupName: String,
        snapshotName: String,
        volumeName: String,
    ): GetSnapshotResult {
        val argument = GetSnapshotPlainArgs(
            accountName = accountName,
            poolName = poolName,
            resourceGroupName = resourceGroupName,
            snapshotName = snapshotName,
            volumeName = volumeName,
        )
        return getSnapshotResultToKotlin(getSnapshotPlain(argument.toJava()).await())
    }

    /**
     * @see [getSnapshot].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;netapp&#46;kotlin&#46;inputs&#46;GetSnapshotPlainArgs].
     * @return Snapshot of a Volume
     */
    public suspend fun getSnapshot(argument: suspend GetSnapshotPlainArgsBuilder.() -> Unit):
        GetSnapshotResult {
        val builder = GetSnapshotPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSnapshotResultToKotlin(getSnapshotPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a snapshot Policy
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01.
     * @param argument null
     * @return Snapshot policy information
     */
    public suspend fun getSnapshotPolicy(argument: GetSnapshotPolicyPlainArgs):
        GetSnapshotPolicyResult =
        getSnapshotPolicyResultToKotlin(getSnapshotPolicyPlain(argument.toJava()).await())

    /**
     * @see [getSnapshotPolicy].
     * @param accountName The name of the NetApp account
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param snapshotPolicyName The name of the snapshot policy
     * @return Snapshot policy information
     */
    public suspend fun getSnapshotPolicy(
        accountName: String,
        resourceGroupName: String,
        snapshotPolicyName: String,
    ): GetSnapshotPolicyResult {
        val argument = GetSnapshotPolicyPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            snapshotPolicyName = snapshotPolicyName,
        )
        return getSnapshotPolicyResultToKotlin(getSnapshotPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getSnapshotPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;netapp&#46;kotlin&#46;inputs&#46;GetSnapshotPolicyPlainArgs].
     * @return Snapshot policy information
     */
    public suspend
    fun getSnapshotPolicy(argument: suspend GetSnapshotPolicyPlainArgsBuilder.() -> Unit):
        GetSnapshotPolicyResult {
        val builder = GetSnapshotPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSnapshotPolicyResultToKotlin(getSnapshotPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the path associated with the subvolumeName provided
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01.
     * @param argument null
     * @return Subvolume Information properties
     */
    public suspend fun getSubvolume(argument: GetSubvolumePlainArgs): GetSubvolumeResult =
        getSubvolumeResultToKotlin(getSubvolumePlain(argument.toJava()).await())

    /**
     * @see [getSubvolume].
     * @param accountName The name of the NetApp account
     * @param poolName The name of the capacity pool
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param subvolumeName The name of the subvolume.
     * @param volumeName The name of the volume
     * @return Subvolume Information properties
     */
    public suspend fun getSubvolume(
        accountName: String,
        poolName: String,
        resourceGroupName: String,
        subvolumeName: String,
        volumeName: String,
    ): GetSubvolumeResult {
        val argument = GetSubvolumePlainArgs(
            accountName = accountName,
            poolName = poolName,
            resourceGroupName = resourceGroupName,
            subvolumeName = subvolumeName,
            volumeName = volumeName,
        )
        return getSubvolumeResultToKotlin(getSubvolumePlain(argument.toJava()).await())
    }

    /**
     * @see [getSubvolume].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;netapp&#46;kotlin&#46;inputs&#46;GetSubvolumePlainArgs].
     * @return Subvolume Information properties
     */
    public suspend fun getSubvolume(argument: suspend GetSubvolumePlainArgsBuilder.() -> Unit):
        GetSubvolumeResult {
        val builder = GetSubvolumePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubvolumeResultToKotlin(getSubvolumePlain(builtArgument.toJava()).await())
    }

    /**
     * Get details of the specified subvolume
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01.
     * @param argument null
     * @return Result of the post subvolume and action is to get metadata of the subvolume.
     */
    public suspend fun getSubvolumeMetadata(argument: GetSubvolumeMetadataPlainArgs):
        GetSubvolumeMetadataResult =
        getSubvolumeMetadataResultToKotlin(getSubvolumeMetadataPlain(argument.toJava()).await())

    /**
     * @see [getSubvolumeMetadata].
     * @param accountName The name of the NetApp account
     * @param poolName The name of the capacity pool
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param subvolumeName The name of the subvolume.
     * @param volumeName The name of the volume
     * @return Result of the post subvolume and action is to get metadata of the subvolume.
     */
    public suspend fun getSubvolumeMetadata(
        accountName: String,
        poolName: String,
        resourceGroupName: String,
        subvolumeName: String,
        volumeName: String,
    ): GetSubvolumeMetadataResult {
        val argument = GetSubvolumeMetadataPlainArgs(
            accountName = accountName,
            poolName = poolName,
            resourceGroupName = resourceGroupName,
            subvolumeName = subvolumeName,
            volumeName = volumeName,
        )
        return getSubvolumeMetadataResultToKotlin(getSubvolumeMetadataPlain(argument.toJava()).await())
    }

    /**
     * @see [getSubvolumeMetadata].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;netapp&#46;kotlin&#46;inputs&#46;GetSubvolumeMetadataPlainArgs].
     * @return Result of the post subvolume and action is to get metadata of the subvolume.
     */
    public suspend
    fun getSubvolumeMetadata(argument: suspend GetSubvolumeMetadataPlainArgsBuilder.() -> Unit):
        GetSubvolumeMetadataResult {
        val builder = GetSubvolumeMetadataPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubvolumeMetadataResultToKotlin(getSubvolumeMetadataPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the details of the specified volume
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2017-08-15, 2019-05-01, 2019-07-01, 2019-08-01, 2020-02-01, 2021-10-01, 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01.
     * @param argument null
     * @return Volume resource
     */
    public suspend fun getVolume(argument: GetVolumePlainArgs): GetVolumeResult =
        getVolumeResultToKotlin(getVolumePlain(argument.toJava()).await())

    /**
     * @see [getVolume].
     * @param accountName The name of the NetApp account
     * @param poolName The name of the capacity pool
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param volumeName The name of the volume
     * @return Volume resource
     */
    public suspend fun getVolume(
        accountName: String,
        poolName: String,
        resourceGroupName: String,
        volumeName: String,
    ): GetVolumeResult {
        val argument = GetVolumePlainArgs(
            accountName = accountName,
            poolName = poolName,
            resourceGroupName = resourceGroupName,
            volumeName = volumeName,
        )
        return getVolumeResultToKotlin(getVolumePlain(argument.toJava()).await())
    }

    /**
     * @see [getVolume].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;netapp&#46;kotlin&#46;inputs&#46;GetVolumePlainArgs].
     * @return Volume resource
     */
    public suspend fun getVolume(argument: suspend GetVolumePlainArgsBuilder.() -> Unit):
        GetVolumeResult {
        val builder = GetVolumePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVolumeResultToKotlin(getVolumePlain(builtArgument.toJava()).await())
    }

    /**
     * Get details of the specified volume group
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2021-10-01, 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01.
     * @param argument null
     * @return Volume group resource for create
     */
    public suspend fun getVolumeGroup(argument: GetVolumeGroupPlainArgs): GetVolumeGroupResult =
        getVolumeGroupResultToKotlin(getVolumeGroupPlain(argument.toJava()).await())

    /**
     * @see [getVolumeGroup].
     * @param accountName The name of the NetApp account
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param volumeGroupName The name of the volumeGroup
     * @return Volume group resource for create
     */
    public suspend fun getVolumeGroup(
        accountName: String,
        resourceGroupName: String,
        volumeGroupName: String,
    ): GetVolumeGroupResult {
        val argument = GetVolumeGroupPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
            volumeGroupName = volumeGroupName,
        )
        return getVolumeGroupResultToKotlin(getVolumeGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getVolumeGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;netapp&#46;kotlin&#46;inputs&#46;GetVolumeGroupPlainArgs].
     * @return Volume group resource for create
     */
    public suspend fun getVolumeGroup(argument: suspend GetVolumeGroupPlainArgsBuilder.() -> Unit):
        GetVolumeGroupResult {
        val builder = GetVolumeGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVolumeGroupResultToKotlin(getVolumeGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns the list of group Ids for a specific LDAP User
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01.
     * @param argument null
     * @return Group Id list for Ldap user
     */
    public suspend fun getVolumeGroupIdForLdapUser(argument: GetVolumeGroupIdForLdapUserPlainArgs):
        GetVolumeGroupIdForLdapUserResult =
        getVolumeGroupIdForLdapUserResultToKotlin(getVolumeGroupIdForLdapUserPlain(argument.toJava()).await())

    /**
     * @see [getVolumeGroupIdForLdapUser].
     * @param accountName The name of the NetApp account
     * @param poolName The name of the capacity pool
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param username username is required to fetch the group to which user is part of
     * @param volumeName The name of the volume
     * @return Group Id list for Ldap user
     */
    public suspend fun getVolumeGroupIdForLdapUser(
        accountName: String,
        poolName: String,
        resourceGroupName: String,
        username: String,
        volumeName: String,
    ): GetVolumeGroupIdForLdapUserResult {
        val argument = GetVolumeGroupIdForLdapUserPlainArgs(
            accountName = accountName,
            poolName = poolName,
            resourceGroupName = resourceGroupName,
            username = username,
            volumeName = volumeName,
        )
        return getVolumeGroupIdForLdapUserResultToKotlin(getVolumeGroupIdForLdapUserPlain(argument.toJava()).await())
    }

    /**
     * @see [getVolumeGroupIdForLdapUser].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;netapp&#46;kotlin&#46;inputs&#46;GetVolumeGroupIdForLdapUserPlainArgs].
     * @return Group Id list for Ldap user
     */
    public suspend
    fun getVolumeGroupIdForLdapUser(argument: suspend GetVolumeGroupIdForLdapUserPlainArgsBuilder.() -> Unit):
        GetVolumeGroupIdForLdapUserResult {
        val builder = GetVolumeGroupIdForLdapUserPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVolumeGroupIdForLdapUserResultToKotlin(getVolumeGroupIdForLdapUserPlain(builtArgument.toJava()).await())
    }

    /**
     * Get details of the specified quota rule
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01.
     * @param argument null
     * @return Quota Rule of a Volume
     */
    public suspend fun getVolumeQuotaRule(argument: GetVolumeQuotaRulePlainArgs):
        GetVolumeQuotaRuleResult =
        getVolumeQuotaRuleResultToKotlin(getVolumeQuotaRulePlain(argument.toJava()).await())

    /**
     * @see [getVolumeQuotaRule].
     * @param accountName The name of the NetApp account
     * @param poolName The name of the capacity pool
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param volumeName The name of the volume
     * @param volumeQuotaRuleName The name of volume quota rule
     * @return Quota Rule of a Volume
     */
    public suspend fun getVolumeQuotaRule(
        accountName: String,
        poolName: String,
        resourceGroupName: String,
        volumeName: String,
        volumeQuotaRuleName: String,
    ): GetVolumeQuotaRuleResult {
        val argument = GetVolumeQuotaRulePlainArgs(
            accountName = accountName,
            poolName = poolName,
            resourceGroupName = resourceGroupName,
            volumeName = volumeName,
            volumeQuotaRuleName = volumeQuotaRuleName,
        )
        return getVolumeQuotaRuleResultToKotlin(getVolumeQuotaRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getVolumeQuotaRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;netapp&#46;kotlin&#46;inputs&#46;GetVolumeQuotaRulePlainArgs].
     * @return Quota Rule of a Volume
     */
    public suspend
    fun getVolumeQuotaRule(argument: suspend GetVolumeQuotaRulePlainArgsBuilder.() -> Unit):
        GetVolumeQuotaRuleResult {
        val builder = GetVolumeQuotaRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVolumeQuotaRuleResultToKotlin(getVolumeQuotaRulePlain(builtArgument.toJava()).await())
    }

    /**
     * List all replications for a specified volume
     * Azure REST API version: 2022-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01.
     * @param argument null
     * @return List Replications
     */
    public suspend fun listVolumeReplications(argument: ListVolumeReplicationsPlainArgs):
        ListVolumeReplicationsResult =
        listVolumeReplicationsResultToKotlin(listVolumeReplicationsPlain(argument.toJava()).await())

    /**
     * @see [listVolumeReplications].
     * @param accountName The name of the NetApp account
     * @param poolName The name of the capacity pool
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param volumeName The name of the volume
     * @return List Replications
     */
    public suspend fun listVolumeReplications(
        accountName: String,
        poolName: String,
        resourceGroupName: String,
        volumeName: String,
    ): ListVolumeReplicationsResult {
        val argument = ListVolumeReplicationsPlainArgs(
            accountName = accountName,
            poolName = poolName,
            resourceGroupName = resourceGroupName,
            volumeName = volumeName,
        )
        return listVolumeReplicationsResultToKotlin(listVolumeReplicationsPlain(argument.toJava()).await())
    }

    /**
     * @see [listVolumeReplications].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;netapp&#46;kotlin&#46;inputs&#46;ListVolumeReplicationsPlainArgs].
     * @return List Replications
     */
    public suspend
    fun listVolumeReplications(argument: suspend ListVolumeReplicationsPlainArgsBuilder.() -> Unit):
        ListVolumeReplicationsResult {
        val builder = ListVolumeReplicationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listVolumeReplicationsResultToKotlin(listVolumeReplicationsPlain(builtArgument.toJava()).await())
    }
}
