@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.VolumeArgs.builder
import com.pulumi.azurenative.netapp.kotlin.enums.AvsDataStore
import com.pulumi.azurenative.netapp.kotlin.enums.EnableSubvolumes
import com.pulumi.azurenative.netapp.kotlin.enums.EncryptionKeySource
import com.pulumi.azurenative.netapp.kotlin.enums.NetworkFeatures
import com.pulumi.azurenative.netapp.kotlin.enums.SecurityStyle
import com.pulumi.azurenative.netapp.kotlin.enums.ServiceLevel
import com.pulumi.azurenative.netapp.kotlin.enums.SmbAccessBasedEnumeration
import com.pulumi.azurenative.netapp.kotlin.enums.SmbNonBrowsable
import com.pulumi.azurenative.netapp.kotlin.inputs.PlacementKeyValuePairsArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.PlacementKeyValuePairsArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.VolumePropertiesDataProtectionArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.VolumePropertiesDataProtectionArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.VolumePropertiesExportPolicyArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.VolumePropertiesExportPolicyArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Volume resource
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2017-08-15, 2019-05-01, 2019-07-01, 2019-08-01, 2020-02-01, 2021-10-01, 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01.
 * ## Example Usage
 * ### Volumes_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volume = new AzureNative.NetApp.Volume("volume", new()
 *     {
 *         AccountName = "account1",
 *         CreationToken = "my-unique-file-path",
 *         Location = "eastus",
 *         PoolName = "pool1",
 *         ResourceGroupName = "myRG",
 *         ServiceLevel = "Premium",
 *         SubnetId = "/subscriptions/9760acf5-4638-11e7-9bdb-020073ca7778/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3",
 *         UsageThreshold = 107374182400,
 *         VolumeName = "volume1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewVolume(ctx, "volume", &netapp.VolumeArgs{
 * 			AccountName:       pulumi.String("account1"),
 * 			CreationToken:     pulumi.String("my-unique-file-path"),
 * 			Location:          pulumi.String("eastus"),
 * 			PoolName:          pulumi.String("pool1"),
 * 			ResourceGroupName: pulumi.String("myRG"),
 * 			ServiceLevel:      pulumi.String("Premium"),
 * 			SubnetId:          pulumi.String("/subscriptions/9760acf5-4638-11e7-9bdb-020073ca7778/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3"),
 * 			UsageThreshold:    pulumi.Float64(107374182400),
 * 			VolumeName:        pulumi.String("volume1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.Volume;
 * import com.pulumi.azurenative.netapp.VolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volume = new Volume("volume", VolumeArgs.builder()
 *             .accountName("account1")
 *             .creationToken("my-unique-file-path")
 *             .location("eastus")
 *             .poolName("pool1")
 *             .resourceGroupName("myRG")
 *             .serviceLevel("Premium")
 *             .subnetId("/subscriptions/9760acf5-4638-11e7-9bdb-020073ca7778/resourceGroups/myRP/providers/Microsoft.Network/virtualNetworks/testvnet3/subnets/testsubnet3")
 *             .usageThreshold(107374182400)
 *             .volumeName("volume1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:Volume account1/pool1/volume1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/capacityPools/{poolName}/volumes/{volumeName}
 * ```
 * @property accountName The name of the NetApp account
 * @property avsDataStore Specifies whether the volume is enabled for Azure VMware Solution (AVS) datastore purpose
 * @property backupId UUID v4 or resource identifier used to identify the Backup.
 * @property capacityPoolResourceId Pool Resource Id used in case of creating a volume through volume group
 * @property coolAccess Specifies whether Cool Access(tiering) is enabled for the volume.
 * @property coolnessPeriod Specifies the number of days after which data that is not accessed by clients will be tiered.
 * @property creationToken A unique file path for the volume. Used when creating mount targets
 * @property dataProtection DataProtection type volumes include an object containing details of the replication
 * @property defaultGroupQuotaInKiBs Default group quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
 * @property defaultUserQuotaInKiBs Default user quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
 * @property deleteBaseSnapshot If enabled (true) the snapshot the volume was created from will be automatically deleted after the volume create operation has finished.  Defaults to false
 * @property enableSubvolumes Flag indicating whether subvolume operations are enabled on the volume
 * @property encryptionKeySource Source of key used to encrypt data in volume. Applicable if NetApp account has encryption.keySource = 'Microsoft.KeyVault'. Possible values (case-insensitive) are: 'Microsoft.NetApp, Microsoft.KeyVault'
 * @property exportPolicy Set of export policy rules
 * @property isDefaultQuotaEnabled Specifies if default quota is enabled for the volume.
 * @property isLargeVolume Specifies whether volume is a Large Volume or Regular Volume.
 * @property isRestoring Restoring
 * @property kerberosEnabled Describe if a volume is KerberosEnabled. To be use with swagger version 2020-05-01 or later
 * @property keyVaultPrivateEndpointResourceId The resource ID of private endpoint for KeyVault. It must reside in the same VNET as the volume. Only applicable if encryptionKeySource = 'Microsoft.KeyVault'.
 * @property ldapEnabled Specifies whether LDAP is enabled or not for a given NFS volume.
 * @property location The geo-location where the resource lives
 * @property networkFeatures Basic network, or Standard features available to the volume.
 * @property placementRules Application specific placement rules for the particular volume
 * @property poolName The name of the capacity pool
 * @property protocolTypes Set of protocol types, default NFSv3, CIFS for SMB protocol
 * @property proximityPlacementGroup Proximity placement group associated with the volume
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property securityStyle The security style of volume, default unix, defaults to ntfs for dual protocol or CIFS protocol
 * @property serviceLevel The service level of the file system
 * @property smbAccessBasedEnumeration Enables access based enumeration share property for SMB Shares. Only applicable for SMB/DualProtocol volume
 * @property smbContinuouslyAvailable Enables continuously available share property for smb volume. Only applicable for SMB volume
 * @property smbEncryption Enables encryption for in-flight smb3 data. Only applicable for SMB/DualProtocol volume. To be used with swagger version 2020-08-01 or later
 * @property smbNonBrowsable Enables non browsable property for SMB Shares. Only applicable for SMB/DualProtocol volume
 * @property snapshotDirectoryVisible If enabled (true) the volume will contain a read-only snapshot directory which provides access to each of the volume's snapshots (defaults to true).
 * @property snapshotId UUID v4 or resource identifier used to identify the Snapshot.
 * @property subnetId The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes
 * @property tags Resource tags.
 * @property throughputMibps
 * @property unixPermissions UNIX permissions for NFS volume accepted in octal 4 digit format. First digit selects the set user ID(4), set group ID (2) and sticky (1) attributes. Second digit selects permission for the owner of the file: read (4), write (2) and execute (1). Third selects permissions for other users in the same group. the fourth for other users not in the group. 0755 - gives read/write/execute permissions to owner and read/execute to group and other users.
 * @property usageThreshold Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB, 500Tib for LargeVolume. Specified in bytes.
 * @property volumeName The name of the volume
 * @property volumeSpecName Volume spec name is the application specific designation or identifier for the particular volume in a volume group for e.g. data, log
 * @property volumeType What type of volume is this. For destination volumes in Cross Region Replication, set type to DataProtection
 * @property zones Availability Zone
 */
public data class VolumeArgs(
    public val accountName: Output<String>? = null,
    public val avsDataStore: Output<Either<String, AvsDataStore>>? = null,
    public val backupId: Output<String>? = null,
    public val capacityPoolResourceId: Output<String>? = null,
    public val coolAccess: Output<Boolean>? = null,
    public val coolnessPeriod: Output<Int>? = null,
    public val creationToken: Output<String>? = null,
    public val dataProtection: Output<VolumePropertiesDataProtectionArgs>? = null,
    public val defaultGroupQuotaInKiBs: Output<Double>? = null,
    public val defaultUserQuotaInKiBs: Output<Double>? = null,
    public val deleteBaseSnapshot: Output<Boolean>? = null,
    public val enableSubvolumes: Output<Either<String, EnableSubvolumes>>? = null,
    public val encryptionKeySource: Output<Either<String, EncryptionKeySource>>? = null,
    public val exportPolicy: Output<VolumePropertiesExportPolicyArgs>? = null,
    public val isDefaultQuotaEnabled: Output<Boolean>? = null,
    public val isLargeVolume: Output<Boolean>? = null,
    public val isRestoring: Output<Boolean>? = null,
    public val kerberosEnabled: Output<Boolean>? = null,
    public val keyVaultPrivateEndpointResourceId: Output<String>? = null,
    public val ldapEnabled: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val networkFeatures: Output<Either<String, NetworkFeatures>>? = null,
    public val placementRules: Output<List<PlacementKeyValuePairsArgs>>? = null,
    public val poolName: Output<String>? = null,
    public val protocolTypes: Output<List<String>>? = null,
    public val proximityPlacementGroup: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securityStyle: Output<Either<String, SecurityStyle>>? = null,
    public val serviceLevel: Output<Either<String, ServiceLevel>>? = null,
    public val smbAccessBasedEnumeration: Output<Either<String, SmbAccessBasedEnumeration>>? = null,
    public val smbContinuouslyAvailable: Output<Boolean>? = null,
    public val smbEncryption: Output<Boolean>? = null,
    public val smbNonBrowsable: Output<Either<String, SmbNonBrowsable>>? = null,
    public val snapshotDirectoryVisible: Output<Boolean>? = null,
    public val snapshotId: Output<String>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val throughputMibps: Output<Double>? = null,
    public val unixPermissions: Output<String>? = null,
    public val usageThreshold: Output<Double>? = null,
    public val volumeName: Output<String>? = null,
    public val volumeSpecName: Output<String>? = null,
    public val volumeType: Output<String>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.VolumeArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.VolumeArgs =
        com.pulumi.azurenative.netapp.VolumeArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .avsDataStore(
                avsDataStore?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .backupId(backupId?.applyValue({ args0 -> args0 }))
            .capacityPoolResourceId(capacityPoolResourceId?.applyValue({ args0 -> args0 }))
            .coolAccess(coolAccess?.applyValue({ args0 -> args0 }))
            .coolnessPeriod(coolnessPeriod?.applyValue({ args0 -> args0 }))
            .creationToken(creationToken?.applyValue({ args0 -> args0 }))
            .dataProtection(dataProtection?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .defaultGroupQuotaInKiBs(defaultGroupQuotaInKiBs?.applyValue({ args0 -> args0 }))
            .defaultUserQuotaInKiBs(defaultUserQuotaInKiBs?.applyValue({ args0 -> args0 }))
            .deleteBaseSnapshot(deleteBaseSnapshot?.applyValue({ args0 -> args0 }))
            .enableSubvolumes(
                enableSubvolumes?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .encryptionKeySource(
                encryptionKeySource?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .exportPolicy(exportPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .isDefaultQuotaEnabled(isDefaultQuotaEnabled?.applyValue({ args0 -> args0 }))
            .isLargeVolume(isLargeVolume?.applyValue({ args0 -> args0 }))
            .isRestoring(isRestoring?.applyValue({ args0 -> args0 }))
            .kerberosEnabled(kerberosEnabled?.applyValue({ args0 -> args0 }))
            .keyVaultPrivateEndpointResourceId(
                keyVaultPrivateEndpointResourceId?.applyValue({ args0 ->
                    args0
                }),
            )
            .ldapEnabled(ldapEnabled?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkFeatures(
                networkFeatures?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .placementRules(
                placementRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .poolName(poolName?.applyValue({ args0 -> args0 }))
            .protocolTypes(protocolTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .proximityPlacementGroup(proximityPlacementGroup?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securityStyle(
                securityStyle?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .serviceLevel(
                serviceLevel?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .smbAccessBasedEnumeration(
                smbAccessBasedEnumeration?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .smbContinuouslyAvailable(smbContinuouslyAvailable?.applyValue({ args0 -> args0 }))
            .smbEncryption(smbEncryption?.applyValue({ args0 -> args0 }))
            .smbNonBrowsable(
                smbNonBrowsable?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .snapshotDirectoryVisible(snapshotDirectoryVisible?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .throughputMibps(throughputMibps?.applyValue({ args0 -> args0 }))
            .unixPermissions(unixPermissions?.applyValue({ args0 -> args0 }))
            .usageThreshold(usageThreshold?.applyValue({ args0 -> args0 }))
            .volumeName(volumeName?.applyValue({ args0 -> args0 }))
            .volumeSpecName(volumeSpecName?.applyValue({ args0 -> args0 }))
            .volumeType(volumeType?.applyValue({ args0 -> args0 }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [VolumeArgs].
 */
@PulumiTagMarker
public class VolumeArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var avsDataStore: Output<Either<String, AvsDataStore>>? = null

    private var backupId: Output<String>? = null

    private var capacityPoolResourceId: Output<String>? = null

    private var coolAccess: Output<Boolean>? = null

    private var coolnessPeriod: Output<Int>? = null

    private var creationToken: Output<String>? = null

    private var dataProtection: Output<VolumePropertiesDataProtectionArgs>? = null

    private var defaultGroupQuotaInKiBs: Output<Double>? = null

    private var defaultUserQuotaInKiBs: Output<Double>? = null

    private var deleteBaseSnapshot: Output<Boolean>? = null

    private var enableSubvolumes: Output<Either<String, EnableSubvolumes>>? = null

    private var encryptionKeySource: Output<Either<String, EncryptionKeySource>>? = null

    private var exportPolicy: Output<VolumePropertiesExportPolicyArgs>? = null

    private var isDefaultQuotaEnabled: Output<Boolean>? = null

    private var isLargeVolume: Output<Boolean>? = null

    private var isRestoring: Output<Boolean>? = null

    private var kerberosEnabled: Output<Boolean>? = null

    private var keyVaultPrivateEndpointResourceId: Output<String>? = null

    private var ldapEnabled: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var networkFeatures: Output<Either<String, NetworkFeatures>>? = null

    private var placementRules: Output<List<PlacementKeyValuePairsArgs>>? = null

    private var poolName: Output<String>? = null

    private var protocolTypes: Output<List<String>>? = null

    private var proximityPlacementGroup: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var securityStyle: Output<Either<String, SecurityStyle>>? = null

    private var serviceLevel: Output<Either<String, ServiceLevel>>? = null

    private var smbAccessBasedEnumeration: Output<Either<String, SmbAccessBasedEnumeration>>? = null

    private var smbContinuouslyAvailable: Output<Boolean>? = null

    private var smbEncryption: Output<Boolean>? = null

    private var smbNonBrowsable: Output<Either<String, SmbNonBrowsable>>? = null

    private var snapshotDirectoryVisible: Output<Boolean>? = null

    private var snapshotId: Output<String>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var throughputMibps: Output<Double>? = null

    private var unixPermissions: Output<String>? = null

    private var usageThreshold: Output<Double>? = null

    private var volumeName: Output<String>? = null

    private var volumeSpecName: Output<String>? = null

    private var volumeType: Output<String>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("uvvjhqwmhetdngdh")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Specifies whether the volume is enabled for Azure VMware Solution (AVS) datastore purpose
     */
    @JvmName("eudpcllljsmuooug")
    public suspend fun avsDataStore(`value`: Output<Either<String, AvsDataStore>>) {
        this.avsDataStore = value
    }

    /**
     * @param value UUID v4 or resource identifier used to identify the Backup.
     */
    @JvmName("gugqbkmcadwnrskt")
    public suspend fun backupId(`value`: Output<String>) {
        this.backupId = value
    }

    /**
     * @param value Pool Resource Id used in case of creating a volume through volume group
     */
    @JvmName("cotcadjyxfclthmr")
    public suspend fun capacityPoolResourceId(`value`: Output<String>) {
        this.capacityPoolResourceId = value
    }

    /**
     * @param value Specifies whether Cool Access(tiering) is enabled for the volume.
     */
    @JvmName("xyynsxeaovxqmrnw")
    public suspend fun coolAccess(`value`: Output<Boolean>) {
        this.coolAccess = value
    }

    /**
     * @param value Specifies the number of days after which data that is not accessed by clients will be tiered.
     */
    @JvmName("vmovrqmxixiviqoe")
    public suspend fun coolnessPeriod(`value`: Output<Int>) {
        this.coolnessPeriod = value
    }

    /**
     * @param value A unique file path for the volume. Used when creating mount targets
     */
    @JvmName("yhdmqjqaconwesgb")
    public suspend fun creationToken(`value`: Output<String>) {
        this.creationToken = value
    }

    /**
     * @param value DataProtection type volumes include an object containing details of the replication
     */
    @JvmName("huxgpvlctivdhocw")
    public suspend fun dataProtection(`value`: Output<VolumePropertiesDataProtectionArgs>) {
        this.dataProtection = value
    }

    /**
     * @param value Default group quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
     */
    @JvmName("hskrwicjiybamljx")
    public suspend fun defaultGroupQuotaInKiBs(`value`: Output<Double>) {
        this.defaultGroupQuotaInKiBs = value
    }

    /**
     * @param value Default user quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
     */
    @JvmName("ihbnnnwrbdmejrcu")
    public suspend fun defaultUserQuotaInKiBs(`value`: Output<Double>) {
        this.defaultUserQuotaInKiBs = value
    }

    /**
     * @param value If enabled (true) the snapshot the volume was created from will be automatically deleted after the volume create operation has finished.  Defaults to false
     */
    @JvmName("kapyeecooevjtpsa")
    public suspend fun deleteBaseSnapshot(`value`: Output<Boolean>) {
        this.deleteBaseSnapshot = value
    }

    /**
     * @param value Flag indicating whether subvolume operations are enabled on the volume
     */
    @JvmName("tgoqecgyenrkgtxh")
    public suspend fun enableSubvolumes(`value`: Output<Either<String, EnableSubvolumes>>) {
        this.enableSubvolumes = value
    }

    /**
     * @param value Source of key used to encrypt data in volume. Applicable if NetApp account has encryption.keySource = 'Microsoft.KeyVault'. Possible values (case-insensitive) are: 'Microsoft.NetApp, Microsoft.KeyVault'
     */
    @JvmName("wpvgtlbtaymclqkv")
    public suspend fun encryptionKeySource(`value`: Output<Either<String, EncryptionKeySource>>) {
        this.encryptionKeySource = value
    }

    /**
     * @param value Set of export policy rules
     */
    @JvmName("hjekvwgdvtelxfsy")
    public suspend fun exportPolicy(`value`: Output<VolumePropertiesExportPolicyArgs>) {
        this.exportPolicy = value
    }

    /**
     * @param value Specifies if default quota is enabled for the volume.
     */
    @JvmName("fvhxgihrihxgcujl")
    public suspend fun isDefaultQuotaEnabled(`value`: Output<Boolean>) {
        this.isDefaultQuotaEnabled = value
    }

    /**
     * @param value Specifies whether volume is a Large Volume or Regular Volume.
     */
    @JvmName("pxgjsbaypornhasp")
    public suspend fun isLargeVolume(`value`: Output<Boolean>) {
        this.isLargeVolume = value
    }

    /**
     * @param value Restoring
     */
    @JvmName("cdnvgoerbglmphcw")
    public suspend fun isRestoring(`value`: Output<Boolean>) {
        this.isRestoring = value
    }

    /**
     * @param value Describe if a volume is KerberosEnabled. To be use with swagger version 2020-05-01 or later
     */
    @JvmName("cpxtrylxmmpdhubv")
    public suspend fun kerberosEnabled(`value`: Output<Boolean>) {
        this.kerberosEnabled = value
    }

    /**
     * @param value The resource ID of private endpoint for KeyVault. It must reside in the same VNET as the volume. Only applicable if encryptionKeySource = 'Microsoft.KeyVault'.
     */
    @JvmName("swlqmnpsnagmkebv")
    public suspend fun keyVaultPrivateEndpointResourceId(`value`: Output<String>) {
        this.keyVaultPrivateEndpointResourceId = value
    }

    /**
     * @param value Specifies whether LDAP is enabled or not for a given NFS volume.
     */
    @JvmName("oxbwykqggqttxjnd")
    public suspend fun ldapEnabled(`value`: Output<Boolean>) {
        this.ldapEnabled = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("cxieygrucjdrkxtg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Basic network, or Standard features available to the volume.
     */
    @JvmName("hotwnepinqvultiy")
    public suspend fun networkFeatures(`value`: Output<Either<String, NetworkFeatures>>) {
        this.networkFeatures = value
    }

    /**
     * @param value Application specific placement rules for the particular volume
     */
    @JvmName("lxwtolorgxyjwkdg")
    public suspend fun placementRules(`value`: Output<List<PlacementKeyValuePairsArgs>>) {
        this.placementRules = value
    }

    @JvmName("mqptfiequsyrjoim")
    public suspend fun placementRules(vararg values: Output<PlacementKeyValuePairsArgs>) {
        this.placementRules = Output.all(values.asList())
    }

    /**
     * @param values Application specific placement rules for the particular volume
     */
    @JvmName("yfutjbmjqupckcbt")
    public suspend fun placementRules(values: List<Output<PlacementKeyValuePairsArgs>>) {
        this.placementRules = Output.all(values)
    }

    /**
     * @param value The name of the capacity pool
     */
    @JvmName("ovkajbyvmqlepbyj")
    public suspend fun poolName(`value`: Output<String>) {
        this.poolName = value
    }

    /**
     * @param value Set of protocol types, default NFSv3, CIFS for SMB protocol
     */
    @JvmName("rwkuvamglqowleqi")
    public suspend fun protocolTypes(`value`: Output<List<String>>) {
        this.protocolTypes = value
    }

    @JvmName("gprcsipcisxoamad")
    public suspend fun protocolTypes(vararg values: Output<String>) {
        this.protocolTypes = Output.all(values.asList())
    }

    /**
     * @param values Set of protocol types, default NFSv3, CIFS for SMB protocol
     */
    @JvmName("opsooxsdnqsbwebs")
    public suspend fun protocolTypes(values: List<Output<String>>) {
        this.protocolTypes = Output.all(values)
    }

    /**
     * @param value Proximity placement group associated with the volume
     */
    @JvmName("wxsitigenfliuedw")
    public suspend fun proximityPlacementGroup(`value`: Output<String>) {
        this.proximityPlacementGroup = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hyhnilgurlxlhtyw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The security style of volume, default unix, defaults to ntfs for dual protocol or CIFS protocol
     */
    @JvmName("voragoecnkasgpcm")
    public suspend fun securityStyle(`value`: Output<Either<String, SecurityStyle>>) {
        this.securityStyle = value
    }

    /**
     * @param value The service level of the file system
     */
    @JvmName("sjqwckwfamogwjgo")
    public suspend fun serviceLevel(`value`: Output<Either<String, ServiceLevel>>) {
        this.serviceLevel = value
    }

    /**
     * @param value Enables access based enumeration share property for SMB Shares. Only applicable for SMB/DualProtocol volume
     */
    @JvmName("knycuuexqllxbuyr")
    public suspend
    fun smbAccessBasedEnumeration(`value`: Output<Either<String, SmbAccessBasedEnumeration>>) {
        this.smbAccessBasedEnumeration = value
    }

    /**
     * @param value Enables continuously available share property for smb volume. Only applicable for SMB volume
     */
    @JvmName("ukiexfhomycabpdk")
    public suspend fun smbContinuouslyAvailable(`value`: Output<Boolean>) {
        this.smbContinuouslyAvailable = value
    }

    /**
     * @param value Enables encryption for in-flight smb3 data. Only applicable for SMB/DualProtocol volume. To be used with swagger version 2020-08-01 or later
     */
    @JvmName("tslxsxusmjchftph")
    public suspend fun smbEncryption(`value`: Output<Boolean>) {
        this.smbEncryption = value
    }

    /**
     * @param value Enables non browsable property for SMB Shares. Only applicable for SMB/DualProtocol volume
     */
    @JvmName("xtulbkfqbdxmobmj")
    public suspend fun smbNonBrowsable(`value`: Output<Either<String, SmbNonBrowsable>>) {
        this.smbNonBrowsable = value
    }

    /**
     * @param value If enabled (true) the volume will contain a read-only snapshot directory which provides access to each of the volume's snapshots (defaults to true).
     */
    @JvmName("arxwkgxiyprkauci")
    public suspend fun snapshotDirectoryVisible(`value`: Output<Boolean>) {
        this.snapshotDirectoryVisible = value
    }

    /**
     * @param value UUID v4 or resource identifier used to identify the Snapshot.
     */
    @JvmName("obiauhdacyeaehhx")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes
     */
    @JvmName("itrdifwimvkqiqky")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("elcfrepuvcttsaen")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("qkteltupxlbiohfd")
    public suspend fun throughputMibps(`value`: Output<Double>) {
        this.throughputMibps = value
    }

    /**
     * @param value UNIX permissions for NFS volume accepted in octal 4 digit format. First digit selects the set user ID(4), set group ID (2) and sticky (1) attributes. Second digit selects permission for the owner of the file: read (4), write (2) and execute (1). Third selects permissions for other users in the same group. the fourth for other users not in the group. 0755 - gives read/write/execute permissions to owner and read/execute to group and other users.
     */
    @JvmName("rrlugeyfvjgtvxuy")
    public suspend fun unixPermissions(`value`: Output<String>) {
        this.unixPermissions = value
    }

    /**
     * @param value Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB, 500Tib for LargeVolume. Specified in bytes.
     */
    @JvmName("ajcihdnsepkloput")
    public suspend fun usageThreshold(`value`: Output<Double>) {
        this.usageThreshold = value
    }

    /**
     * @param value The name of the volume
     */
    @JvmName("akebheuirpnkeyed")
    public suspend fun volumeName(`value`: Output<String>) {
        this.volumeName = value
    }

    /**
     * @param value Volume spec name is the application specific designation or identifier for the particular volume in a volume group for e.g. data, log
     */
    @JvmName("eaurxamgyxybbdtv")
    public suspend fun volumeSpecName(`value`: Output<String>) {
        this.volumeSpecName = value
    }

    /**
     * @param value What type of volume is this. For destination volumes in Cross Region Replication, set type to DataProtection
     */
    @JvmName("gfhfeevafjlbpvnw")
    public suspend fun volumeType(`value`: Output<String>) {
        this.volumeType = value
    }

    /**
     * @param value Availability Zone
     */
    @JvmName("dcidamlsjbelokbf")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("dyuufedsmyxplsdc")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values Availability Zone
     */
    @JvmName("tmlmcwexurboihke")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("owhvffkbexvntkea")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Specifies whether the volume is enabled for Azure VMware Solution (AVS) datastore purpose
     */
    @JvmName("rivetfvsvcyxfugo")
    public suspend fun avsDataStore(`value`: Either<String, AvsDataStore>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.avsDataStore = mapped
    }

    /**
     * @param value Specifies whether the volume is enabled for Azure VMware Solution (AVS) datastore purpose
     */
    @JvmName("qaicascrxrfxhulg")
    public fun avsDataStore(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AvsDataStore>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.avsDataStore = mapped
    }

    /**
     * @param value Specifies whether the volume is enabled for Azure VMware Solution (AVS) datastore purpose
     */
    @JvmName("qcmgxgojsqophnvu")
    public fun avsDataStore(`value`: AvsDataStore) {
        val toBeMapped = Either.ofRight<String, AvsDataStore>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.avsDataStore = mapped
    }

    /**
     * @param value UUID v4 or resource identifier used to identify the Backup.
     */
    @JvmName("ymfloqktpypmpslx")
    public suspend fun backupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupId = mapped
    }

    /**
     * @param value Pool Resource Id used in case of creating a volume through volume group
     */
    @JvmName("ahudnvxdkhlosuxg")
    public suspend fun capacityPoolResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityPoolResourceId = mapped
    }

    /**
     * @param value Specifies whether Cool Access(tiering) is enabled for the volume.
     */
    @JvmName("mudqqyxpdhpemwqb")
    public suspend fun coolAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coolAccess = mapped
    }

    /**
     * @param value Specifies the number of days after which data that is not accessed by clients will be tiered.
     */
    @JvmName("wrmnqenmuisxpeka")
    public suspend fun coolnessPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coolnessPeriod = mapped
    }

    /**
     * @param value A unique file path for the volume. Used when creating mount targets
     */
    @JvmName("lkgbcctyyxmiajju")
    public suspend fun creationToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creationToken = mapped
    }

    /**
     * @param value DataProtection type volumes include an object containing details of the replication
     */
    @JvmName("tpqvorppjqygrfdq")
    public suspend fun dataProtection(`value`: VolumePropertiesDataProtectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataProtection = mapped
    }

    /**
     * @param argument DataProtection type volumes include an object containing details of the replication
     */
    @JvmName("upunnnbevrvlsigl")
    public suspend
    fun dataProtection(argument: suspend VolumePropertiesDataProtectionArgsBuilder.() -> Unit) {
        val toBeMapped = VolumePropertiesDataProtectionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataProtection = mapped
    }

    /**
     * @param value Default group quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
     */
    @JvmName("ytgqprmnnnqsgbpp")
    public suspend fun defaultGroupQuotaInKiBs(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultGroupQuotaInKiBs = mapped
    }

    /**
     * @param value Default user quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
     */
    @JvmName("xxaeejvtrojcnemy")
    public suspend fun defaultUserQuotaInKiBs(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultUserQuotaInKiBs = mapped
    }

    /**
     * @param value If enabled (true) the snapshot the volume was created from will be automatically deleted after the volume create operation has finished.  Defaults to false
     */
    @JvmName("bibfyfmylovgfxvp")
    public suspend fun deleteBaseSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteBaseSnapshot = mapped
    }

    /**
     * @param value Flag indicating whether subvolume operations are enabled on the volume
     */
    @JvmName("tgokkysxigwdmprp")
    public suspend fun enableSubvolumes(`value`: Either<String, EnableSubvolumes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSubvolumes = mapped
    }

    /**
     * @param value Flag indicating whether subvolume operations are enabled on the volume
     */
    @JvmName("xxktshcekfadhory")
    public fun enableSubvolumes(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnableSubvolumes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableSubvolumes = mapped
    }

    /**
     * @param value Flag indicating whether subvolume operations are enabled on the volume
     */
    @JvmName("jnofqdjltirwnjfc")
    public fun enableSubvolumes(`value`: EnableSubvolumes) {
        val toBeMapped = Either.ofRight<String, EnableSubvolumes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableSubvolumes = mapped
    }

    /**
     * @param value Source of key used to encrypt data in volume. Applicable if NetApp account has encryption.keySource = 'Microsoft.KeyVault'. Possible values (case-insensitive) are: 'Microsoft.NetApp, Microsoft.KeyVault'
     */
    @JvmName("xkbcpeqbhqhmtqnj")
    public suspend fun encryptionKeySource(`value`: Either<String, EncryptionKeySource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKeySource = mapped
    }

    /**
     * @param value Source of key used to encrypt data in volume. Applicable if NetApp account has encryption.keySource = 'Microsoft.KeyVault'. Possible values (case-insensitive) are: 'Microsoft.NetApp, Microsoft.KeyVault'
     */
    @JvmName("flrohonuovvmpkif")
    public fun encryptionKeySource(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncryptionKeySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionKeySource = mapped
    }

    /**
     * @param value Source of key used to encrypt data in volume. Applicable if NetApp account has encryption.keySource = 'Microsoft.KeyVault'. Possible values (case-insensitive) are: 'Microsoft.NetApp, Microsoft.KeyVault'
     */
    @JvmName("xbbuccqsgkobvnyh")
    public fun encryptionKeySource(`value`: EncryptionKeySource) {
        val toBeMapped = Either.ofRight<String, EncryptionKeySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionKeySource = mapped
    }

    /**
     * @param value Set of export policy rules
     */
    @JvmName("umelemkqowgyroqm")
    public suspend fun exportPolicy(`value`: VolumePropertiesExportPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportPolicy = mapped
    }

    /**
     * @param argument Set of export policy rules
     */
    @JvmName("yxtofsrhcuqqttvp")
    public suspend
    fun exportPolicy(argument: suspend VolumePropertiesExportPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = VolumePropertiesExportPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.exportPolicy = mapped
    }

    /**
     * @param value Specifies if default quota is enabled for the volume.
     */
    @JvmName("kohbrdhpepukpefk")
    public suspend fun isDefaultQuotaEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDefaultQuotaEnabled = mapped
    }

    /**
     * @param value Specifies whether volume is a Large Volume or Regular Volume.
     */
    @JvmName("mvkfsrgcqovddadp")
    public suspend fun isLargeVolume(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isLargeVolume = mapped
    }

    /**
     * @param value Restoring
     */
    @JvmName("ntjmpmxxelhufiab")
    public suspend fun isRestoring(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isRestoring = mapped
    }

    /**
     * @param value Describe if a volume is KerberosEnabled. To be use with swagger version 2020-05-01 or later
     */
    @JvmName("pdcpvsggromyashe")
    public suspend fun kerberosEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kerberosEnabled = mapped
    }

    /**
     * @param value The resource ID of private endpoint for KeyVault. It must reside in the same VNET as the volume. Only applicable if encryptionKeySource = 'Microsoft.KeyVault'.
     */
    @JvmName("gdsphlvowkfinrhe")
    public suspend fun keyVaultPrivateEndpointResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultPrivateEndpointResourceId = mapped
    }

    /**
     * @param value Specifies whether LDAP is enabled or not for a given NFS volume.
     */
    @JvmName("qwunwcubiycirrak")
    public suspend fun ldapEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ldapEnabled = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("iuugqqkepsqquvpw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Basic network, or Standard features available to the volume.
     */
    @JvmName("plwrqqjgwwwplfgh")
    public suspend fun networkFeatures(`value`: Either<String, NetworkFeatures>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFeatures = mapped
    }

    /**
     * @param value Basic network, or Standard features available to the volume.
     */
    @JvmName("enqdekudqpqjehmh")
    public fun networkFeatures(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkFeatures>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkFeatures = mapped
    }

    /**
     * @param value Basic network, or Standard features available to the volume.
     */
    @JvmName("ehylxicduibongwc")
    public fun networkFeatures(`value`: NetworkFeatures) {
        val toBeMapped = Either.ofRight<String, NetworkFeatures>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkFeatures = mapped
    }

    /**
     * @param value Application specific placement rules for the particular volume
     */
    @JvmName("fvbjhndngxyywjgb")
    public suspend fun placementRules(`value`: List<PlacementKeyValuePairsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementRules = mapped
    }

    /**
     * @param argument Application specific placement rules for the particular volume
     */
    @JvmName("rsqpcocscjritsvc")
    public suspend
    fun placementRules(argument: List<suspend PlacementKeyValuePairsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PlacementKeyValuePairsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.placementRules = mapped
    }

    /**
     * @param argument Application specific placement rules for the particular volume
     */
    @JvmName("tnneeqmmwbknvyol")
    public suspend fun placementRules(
        vararg
        argument: suspend PlacementKeyValuePairsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PlacementKeyValuePairsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.placementRules = mapped
    }

    /**
     * @param argument Application specific placement rules for the particular volume
     */
    @JvmName("ehajsqmykaapromm")
    public suspend
    fun placementRules(argument: suspend PlacementKeyValuePairsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PlacementKeyValuePairsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.placementRules = mapped
    }

    /**
     * @param values Application specific placement rules for the particular volume
     */
    @JvmName("etoyxbrynglhhmsr")
    public suspend fun placementRules(vararg values: PlacementKeyValuePairsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.placementRules = mapped
    }

    /**
     * @param value The name of the capacity pool
     */
    @JvmName("hnaisydyhvxrvqke")
    public suspend fun poolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolName = mapped
    }

    /**
     * @param value Set of protocol types, default NFSv3, CIFS for SMB protocol
     */
    @JvmName("jywnunbcghqwqqfq")
    public suspend fun protocolTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolTypes = mapped
    }

    /**
     * @param values Set of protocol types, default NFSv3, CIFS for SMB protocol
     */
    @JvmName("kdurvftfcbhxdpbe")
    public suspend fun protocolTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocolTypes = mapped
    }

    /**
     * @param value Proximity placement group associated with the volume
     */
    @JvmName("sebblactqdioycue")
    public suspend fun proximityPlacementGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proximityPlacementGroup = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ucmaujripdmverox")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The security style of volume, default unix, defaults to ntfs for dual protocol or CIFS protocol
     */
    @JvmName("hkvkocuadjxafjoe")
    public suspend fun securityStyle(`value`: Either<String, SecurityStyle>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityStyle = mapped
    }

    /**
     * @param value The security style of volume, default unix, defaults to ntfs for dual protocol or CIFS protocol
     */
    @JvmName("aoxjqwkogptghfgf")
    public fun securityStyle(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityStyle>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityStyle = mapped
    }

    /**
     * @param value The security style of volume, default unix, defaults to ntfs for dual protocol or CIFS protocol
     */
    @JvmName("ajyuwqucfuipkktv")
    public fun securityStyle(`value`: SecurityStyle) {
        val toBeMapped = Either.ofRight<String, SecurityStyle>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityStyle = mapped
    }

    /**
     * @param value The service level of the file system
     */
    @JvmName("bhhhlujkyxoasrtr")
    public suspend fun serviceLevel(`value`: Either<String, ServiceLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceLevel = mapped
    }

    /**
     * @param value The service level of the file system
     */
    @JvmName("okyiwplirluyhkby")
    public fun serviceLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServiceLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceLevel = mapped
    }

    /**
     * @param value The service level of the file system
     */
    @JvmName("vnwkkkgxykssjagc")
    public fun serviceLevel(`value`: ServiceLevel) {
        val toBeMapped = Either.ofRight<String, ServiceLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceLevel = mapped
    }

    /**
     * @param value Enables access based enumeration share property for SMB Shares. Only applicable for SMB/DualProtocol volume
     */
    @JvmName("lpnkntxdglywrfwv")
    public suspend
    fun smbAccessBasedEnumeration(`value`: Either<String, SmbAccessBasedEnumeration>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smbAccessBasedEnumeration = mapped
    }

    /**
     * @param value Enables access based enumeration share property for SMB Shares. Only applicable for SMB/DualProtocol volume
     */
    @JvmName("exbcavqqswvjnoaq")
    public fun smbAccessBasedEnumeration(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SmbAccessBasedEnumeration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.smbAccessBasedEnumeration = mapped
    }

    /**
     * @param value Enables access based enumeration share property for SMB Shares. Only applicable for SMB/DualProtocol volume
     */
    @JvmName("lgncmhbtxhtoroqp")
    public fun smbAccessBasedEnumeration(`value`: SmbAccessBasedEnumeration) {
        val toBeMapped = Either.ofRight<String, SmbAccessBasedEnumeration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.smbAccessBasedEnumeration = mapped
    }

    /**
     * @param value Enables continuously available share property for smb volume. Only applicable for SMB volume
     */
    @JvmName("pmjitjxpljevoiam")
    public suspend fun smbContinuouslyAvailable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smbContinuouslyAvailable = mapped
    }

    /**
     * @param value Enables encryption for in-flight smb3 data. Only applicable for SMB/DualProtocol volume. To be used with swagger version 2020-08-01 or later
     */
    @JvmName("hveykouegbjetpga")
    public suspend fun smbEncryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smbEncryption = mapped
    }

    /**
     * @param value Enables non browsable property for SMB Shares. Only applicable for SMB/DualProtocol volume
     */
    @JvmName("ewfnhcbwfxrrosfm")
    public suspend fun smbNonBrowsable(`value`: Either<String, SmbNonBrowsable>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smbNonBrowsable = mapped
    }

    /**
     * @param value Enables non browsable property for SMB Shares. Only applicable for SMB/DualProtocol volume
     */
    @JvmName("nrpyjcwwfbijycpr")
    public fun smbNonBrowsable(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SmbNonBrowsable>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.smbNonBrowsable = mapped
    }

    /**
     * @param value Enables non browsable property for SMB Shares. Only applicable for SMB/DualProtocol volume
     */
    @JvmName("ubppyrvydafngjfo")
    public fun smbNonBrowsable(`value`: SmbNonBrowsable) {
        val toBeMapped = Either.ofRight<String, SmbNonBrowsable>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.smbNonBrowsable = mapped
    }

    /**
     * @param value If enabled (true) the volume will contain a read-only snapshot directory which provides access to each of the volume's snapshots (defaults to true).
     */
    @JvmName("miiwsvsdsnvgpbaq")
    public suspend fun snapshotDirectoryVisible(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotDirectoryVisible = mapped
    }

    /**
     * @param value UUID v4 or resource identifier used to identify the Snapshot.
     */
    @JvmName("ukcmykoshwesjutq")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    /**
     * @param value The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes
     */
    @JvmName("kxthpjwytaevgrfx")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jtqahewsebpvqape")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("dkciyjaleswjjqcm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("kbpvcdxfsbskcwel")
    public suspend fun throughputMibps(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughputMibps = mapped
    }

    /**
     * @param value UNIX permissions for NFS volume accepted in octal 4 digit format. First digit selects the set user ID(4), set group ID (2) and sticky (1) attributes. Second digit selects permission for the owner of the file: read (4), write (2) and execute (1). Third selects permissions for other users in the same group. the fourth for other users not in the group. 0755 - gives read/write/execute permissions to owner and read/execute to group and other users.
     */
    @JvmName("sfddwhxiustankab")
    public suspend fun unixPermissions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unixPermissions = mapped
    }

    /**
     * @param value Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB, 500Tib for LargeVolume. Specified in bytes.
     */
    @JvmName("rldmfvisoskwhmcv")
    public suspend fun usageThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usageThreshold = mapped
    }

    /**
     * @param value The name of the volume
     */
    @JvmName("rjbmfavshrnhibui")
    public suspend fun volumeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeName = mapped
    }

    /**
     * @param value Volume spec name is the application specific designation or identifier for the particular volume in a volume group for e.g. data, log
     */
    @JvmName("mthgodflsqkcjvfr")
    public suspend fun volumeSpecName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeSpecName = mapped
    }

    /**
     * @param value What type of volume is this. For destination volumes in Cross Region Replication, set type to DataProtection
     */
    @JvmName("nuqgsboggbmikmov")
    public suspend fun volumeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeType = mapped
    }

    /**
     * @param value Availability Zone
     */
    @JvmName("tbtwieneqhgurvkk")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values Availability Zone
     */
    @JvmName("jwlgptahnggawsvh")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): VolumeArgs = VolumeArgs(
        accountName = accountName,
        avsDataStore = avsDataStore,
        backupId = backupId,
        capacityPoolResourceId = capacityPoolResourceId,
        coolAccess = coolAccess,
        coolnessPeriod = coolnessPeriod,
        creationToken = creationToken,
        dataProtection = dataProtection,
        defaultGroupQuotaInKiBs = defaultGroupQuotaInKiBs,
        defaultUserQuotaInKiBs = defaultUserQuotaInKiBs,
        deleteBaseSnapshot = deleteBaseSnapshot,
        enableSubvolumes = enableSubvolumes,
        encryptionKeySource = encryptionKeySource,
        exportPolicy = exportPolicy,
        isDefaultQuotaEnabled = isDefaultQuotaEnabled,
        isLargeVolume = isLargeVolume,
        isRestoring = isRestoring,
        kerberosEnabled = kerberosEnabled,
        keyVaultPrivateEndpointResourceId = keyVaultPrivateEndpointResourceId,
        ldapEnabled = ldapEnabled,
        location = location,
        networkFeatures = networkFeatures,
        placementRules = placementRules,
        poolName = poolName,
        protocolTypes = protocolTypes,
        proximityPlacementGroup = proximityPlacementGroup,
        resourceGroupName = resourceGroupName,
        securityStyle = securityStyle,
        serviceLevel = serviceLevel,
        smbAccessBasedEnumeration = smbAccessBasedEnumeration,
        smbContinuouslyAvailable = smbContinuouslyAvailable,
        smbEncryption = smbEncryption,
        smbNonBrowsable = smbNonBrowsable,
        snapshotDirectoryVisible = snapshotDirectoryVisible,
        snapshotId = snapshotId,
        subnetId = subnetId,
        tags = tags,
        throughputMibps = throughputMibps,
        unixPermissions = unixPermissions,
        usageThreshold = usageThreshold,
        volumeName = volumeName,
        volumeSpecName = volumeSpecName,
        volumeType = volumeType,
        zones = zones,
    )
}
