@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.NetApp, Microsoft.KeyVault
 */
public enum class KeySource(
    public val javaValue: com.pulumi.azurenative.netapp.enums.KeySource,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.enums.KeySource> {
    /**
     * Microsoft-managed key encryption
     */
    Microsoft_NetApp(com.pulumi.azurenative.netapp.enums.KeySource.Microsoft_NetApp),

    /**
     * Customer-managed key encryption
     */
    Microsoft_KeyVault(com.pulumi.azurenative.netapp.enums.KeySource.Microsoft_KeyVault),
    ;

    override fun toJava(): com.pulumi.azurenative.netapp.enums.KeySource = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.enums.KeySource): KeySource =
            KeySource.values().first { it.javaValue == javaType }
    }
}
